<?php

namespace App\Console\Commands;

use App\Models\KPIPerfomance;
use App\Models\Tasks;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Auth;
use Carbon\Carbon;

class KPITracker extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'kpi:update';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Every day will update the KPI points';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $userId = Auth::user()->id;
        $tasks  = Tasks::where('user_id', $userId)->get();

        if ($tasks->isEmpty()) {
            return response()->json(['error' => 'No tasks found for this user'], 404);
        }
        foreach ($tasks as $task) {
            if ($task->post_approval === 'yes') {
                continue; // Move to the next task
            }
            $dueDate = Carbon::parse($task->end_date);
            $completionDate = now();
            // Determine KPI points
            if ($completionDate->lt($dueDate)) {
                $kpiPoints = 1;  // Completed before due date
            } elseif ($completionDate->eq($dueDate)) {
                $kpiPoints = 0;  // Completed on due date
            } else {
                $kpiPoints = -1; // Completed after due date
            }

            // Update or create KPI record
            KPIPerfomance::updateOrCreate(
                ['users_id' => $userId, 'tasks_id' => $task->id],
                ['kpi_points' => $kpiPoints, 'updated_at' => now()]
            );
        }

        return response()->json([
            'message' => 'KPI updated successfully for all eligible tasks',
        ]);
    }
}
