<?php

namespace App\Console\Commands;

use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class ServiceMonthlyTasks extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'tasks:create-monthly';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Create tasks for services on the 1st of each month';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $now = Carbon::now();
        $startOfMonth = $now->startOfMonth()->toDateString();
        $endOfMonth = $now->endOfMonth()->toDateString();

        // Example fetching logic: Modify as per your requirements
        $clientServices = DB::table('client_services')->get();

        foreach ($clientServices as $clientService) {
            DB::table('tasks')->insert([
                'clientservices_id' => $clientService->id,
                'clients_id' => $clientService->client_id,
                'start_date' => $startOfMonth,
                'end_date' => $endOfMonth,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }

        $this->info('Monthly tasks created successfully.');
    }
}
