<?php

namespace App\Console\Commands;

use App\Models\Client;
use App\Models\ClientsService;
use App\Models\Service;
use App\Models\Tasks;
use Carbon\Carbon;
use Illuminate\Console\Command;

class TestCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'hello:test';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        /*$result = ClientsService::join('services', 'client_services.services_id', '=', 'services.id')
            ->select('client_services.*', 'services.repeat', 'services.service_name')
            ->get();*/

        $result  = ClientsService::where('status', 'Active')
            ->orderby('created_at')
            ->get();
        foreach ($result as $service) {
            if ($service->id < 10) {
                Tasks::create([
                    'clients_id' => $service['clients_id'],
                    'services_id' => $service['services_id'],
                ]);
                $this->info('Services processed and tasks created successfully.');
            }
        }
    }
    /*protected function insertTask($service)
    {
        Tasks::create([
            'clients_id' => $service['clients_id'],
            'services_id' => $service['services_id'],
            'end_date'   => $service['end_date'],
        ]);
    }
    protected function insertTaskWithRepeat($service, $interval)
    {
        $startDate = Carbon::parse($service->create_at);
        $endDate = Carbon::parse($service->end_date);

        $currentDate = $startDate;

        while ($currentDate <= $endDate) {
            Tasks::create([
                'clients_id' => $service['clients_id'],
                'services_id' => $service['services_id'],
                'start_date' => $currentDate,
                'end_date' => $currentDate,
                // 'status' => $service->status,
            ]);

            $currentDate->add($interval);
        }
    }*/
}
