<?php

namespace App\Http\Controllers;

use App\Models\DispatchJob;
use App\Models\Client;
use App\Models\Client_ContactPerson;
use App\Models\ClientsService;
use App\Models\CompanyType;
use App\Models\ContactPerson;
use App\Models\ContactPersonLimited;
use App\Models\ContactPersonPartner;
use App\Models\ContactPersonSole;
use App\Models\cp_limited;
use App\Models\cp_partners;
use App\Models\LimitedDirector;
use App\Models\LimitedShareholder;
use App\Models\Postcheck_Attachment;
use App\Models\Precheck_Attachment;
use App\Models\Prechecks;
use App\Models\Service;
use App\Models\Tasks;
use Illuminate\Auth\EloquentUserProvider;
use Illuminate\Auth\Events\Validated;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Support\Facades\Validator;

class ClientController extends Controller
{
    public function ClientView($id)
    {
        $client = Client::find($id);
        /************ For Limited Client ***********/
        $compType = $client->company_type;
        $contpersonLtd = ContactPersonLimited::where('client_id', '=', $id)->with('contactPersonltd')->get();
        $contpersonPtner = ContactPersonPartner::where('client_id', '=', $id)->with('contactPersonPtr')->get();
        $contactPerson = ContactPersonSole::where('client_id', '=', $id)->with('contactPersonSole')->get();

        $assignedserv = DB::table('client_services')
            ->join('services', 'client_services.services_id', '=', 'services.id')
            ->select('client_services.*', 'services.service_name')
            ->where('client_services.clients_id', $id)
            ->get();
        $recent =  Tasks::where('clients_id', $id)
            ->with('EachTask', 'userAssign', 'juniorAssign', 'client')->get();

        if ($compType == 'Sole Proprietor') {
            return view('client.views.soleproprietor', compact('client', 'contactPerson', 'recent', 'assignedserv'));
        } elseif ($compType == 'Partnership') {
            return view('client.views.partnership', compact('client', 'contpersonPtner', 'recent', 'assignedserv'));
        } elseif ($compType == 'Limited') {
            return view('client.views.limited', compact('client', 'contpersonLtd', 'recent', 'assignedserv'));
        } else {
            return redirect()->back();
        }
    }

    /****************** Checklist Report ******************/

    public function clientChecklistReport($id)
    {
        $client   = Client::find($id);
        $clientId = $client->id;
        $service = ClientsService::with('service')
            ->where('clients_id', $client->id)->get();

        return view('client.views.checklist.checklist_limited', compact('client', 'service', 'clientId'));
    }

    public function clientChecklistReportPartner($id)
    {
        $client   = Client::find($id);
        $clientId = $client->id;

        $service = ClientsService::with('service')
            ->where('clients_id', $client->id)->get();

        return view('client.views.checklist.checklist_partner', compact('client', 'service', 'clientId'));
    }

    public function clientChecklistReportSole($id)
    {
        $client   = Client::find($id);
        $clientId = $client->id;

        $service = ClientsService::with('service')
            ->where('clients_id', $client->id)->get();

        return view('client.views.checklist.checklist_sole', compact('client', 'service', 'clientId'));
    }
    public function clientChecklistData($id) {}
    public function checklistResultData(Request $request)
    {
        $serviceId     = $request->input('service_id');
        $selectedYear  = $request->input('period');
        $clientId      = $request->input('client');
        $selectedMonth = $request->input('month');

        /*$serviceId     = '56';
        $selectedYear  = '2024';
        $clientId      = '25';
        $selectedMonth = '01';*/

        $data = Tasks::where('clientservices_id', $serviceId)
            ->where('clients_id', $clientId) // Fixed: Changed '$client_id' to 'client_id'
            ->whereMonth('created_at', '=', $selectedMonth)
            ->whereYear('created_at', '=', $selectedYear)
            ->get();

        foreach ($data as $item) {
            /* $attach = Postcheck_Attachment::join('precheck_attachment', 'postcheck_attachment.task_id', '=', 'precheck_attachment.task_id')
                ->select('postcheck_attachment.*', 'precheck_attachment.precheck_attach')
                ->where('postcheck_attachment.task_id', $item->id)
                ->with('postcheckservice')
                ->get();*/
            $post = Postcheck_Attachment::where('task_id', $item->id)
                ->with('postcheckservice')
                ->get();

            $pre = Precheck_Attachment::where('task_id', $item->id)
                ->with('precheckservice')
                ->get();
            $attach = $post->merge($pre);
        }
        return response()->json($attach);
    }

    public function clients()
    {
        $result = Client::with('contactPeople')->get();
        return view('client.clients', compact('result'));
    }

    public function createClient()
    {
        return view('client.createClient');
    }
    //*************  Steps to Create New Client   ******************//
    public function step1(Request $request)
    {
        $compType = $request->input('companytype');
        if ($compType == '0') {
            $comp = 'Sole Proprietor';
            return view('client.soleproprietor', compact('comp'));
        } elseif ($compType == '1') {
            $comp = 'Partnership';
            return view('client.partnership')->with('comp', $comp);
        } elseif ($compType == '2') {
            $comp = 'Limited';
            return view('client.limited')->with('comp', $comp);
        } else {
            return redirect()->route('client.clienttype')->with('message', 'Please select company type!');
        }
    }
    public function step2a()
    {
        return view('client.soleproprietor');
    }

    /************ New Company Formation Sole Propeator ************/
    public function newCompany()
    {
        return view('client.newSole');
    }
    public function newCompanyStore(Request $request)
    {
        $newSole = $request->validate([
            'name'          =>  'required',
            'tradeas'       =>  'required',
            'phone_number'  =>  'required',
            'email'         =>  'required|email',

        ]);
        $newSole = Client::create([
            'name'          => $request->name,
            'tradeas'       => $request->tradeas,
            'phone_number'  => $request->phone_number,
            'email'         => $request->email,
            'isNew'         => $request->isNew,
            'company_type'  => $request->company_type
        ]);
        return redirect()->route('client.clients');
    }

    /********************* Assign Contact Person to New Company Formation ***************************/

    public function contactPersonForNewClient()
    {
        $contactPerson = ContactPerson::all();
        return view('client.contactPerson', compact('contactPerson'));
    }

    /********************* Assign Contact Person to New Company Formation ***************************/
    public function newSoleAssignContact(Request $request)
    {
        $clientName = $request->input('clientName');
        $contactper = Client::where('name', '=', $clientName)->firstOrFail();
        $id = $contactper->id;
        $contact = Client::find($id);
        if ($contact) {
            $contact->contactPerson_id = $request->input('contactPerson');
            $contact->update();
        }

        return redirect()->route('client.clients');
    }
    /****************** CLient Services Supspend ****************/
    public function suspendClientService($id)
    {
        $suspend = ClientsService::find($id);
        $suspend->status = "Suspend";
        $suspend->update();
        return redirect()->back()->with('message', 'Service Suspended successfully!');
    }
    /****************** CLient Services Activate ****************/
    public function activateClientService($id)
    {
        $suspend = ClientsService::find($id);
        $suspend->status = "Active";
        $suspend->update();
        return redirect()->back()->with('message', 'Service Activated Successfully!');
    }
    public function newCompanyService()
    {
        $service = Service::all();
        return view('client.servicelist', compact('service'));
    }
    public function newCompanyServiceStore(Request $request)
    {
        $addClient = Client::latest('created_at')->first();
        return redirect()->route('client.clients');
    }

    /********************* New Company Formation Partner Company ***************************/
    public function newCompanyPartner()
    {
        return view('client.newPartner');
    }
    public function newCompanyPartnerDataStore(Request $request)
    {
        $partnerFormation = Client::create([
            'name'         => $request['name'],
            'phone_number' => $request['phone_number'],
            'email'        => $request['email'],
            'isNew'        => $request['isNew'],
            'company_type' => $request['company_type']
        ]);

        return redirect()->route('client.clients');
    }
    /********************* New Company Formation Limited Company ***************************/
    public function newCompanyLimited()
    {
        return view('client.newLimited');
    }
    public function newCompanyLimitedData(Request $request)
    {
        $limitedFormation = Client::create([
            'name'         => $request['name'],
            'phone_number' => $request['phone_number'],
            'email'        => $request['email'],
            'isNew'        => $request['isNew'],
            'company_type' => $request['company_type']
        ]);

        return redirect()->route('client.clients');
    }

    /************* Create Client Sole Propeator Company *******************/
    public function step2(Request $request)
    {

        $validator = Validator::make($request->all(), [
            'name'           =>     '',
            'address1'       =>     '',
            'plot'           =>     '',
            'block'          =>     '',
            'house'          =>     '',
            'city'           =>     '',
            'phone_number'   =>     '',
            'email'          =>     '',
            'tin_number'     =>     '',

        ]);
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        } else {
            $tincertFile = null;
            if ($request->hasFile('tincert')) {
                $pdfFile = $request->file('tincert');
                $tincertFile = uniqid() . '.' . $pdfFile->getClientOriginalExtension();
                $pdfFile->storeAs('public/upload', $tincertFile);
            }
            $certRegName = null;
            if ($request->hasFile('certReg')) {
                $certReg = $request->file('certReg');
                $certRegName =  uniqid() . '.' . $certReg->getClientOriginalExtension();
                $certReg->storeAs('public/upload', $certRegName);
            }
            $certExtrName = null;
            if ($request->hasFile('certExtr')) {
                $certExtr = $request->file('certExtr');
                $certExtrName =  uniqid() . '.' . $certExtr->getClientOriginalExtension();
                $certExtr->storeAs('public/upload', $certExtrName);
            }
            $certVatName = null;
            if ($request->hasFile('certVat')) {
                $certVat = $request->file('certVat');
                $certVatName =  uniqid() . '.' . $certVat->getClientOriginalExtension();
                $certVat->storeAs('public/upload', $certVatName);
            }
            $proprietor = new Client();
            $proprietor->name              =    $request->name;
            $proprietor->tradeas           =    $request->tradeas;
            $proprietor->address1          =    $request->address1;
            $proprietor->block             =    $request->block;
            $proprietor->plot              =    $request->plot;
            $proprietor->house             =    $request->house;
            $proprietor->city              =    $request->city;
            $proprietor->phone_number      =    $request->phone_number;
            $proprietor->email             =    $request->email;
            $proprietor->tin_number        =    $request->tin_number;
            $proprietor->tinCert           =    $tincertFile;
            $proprietor->vrn               =    $request->vrn;
            $proprietor->certVat           =    $certVatName;
            // $proprietor->efin              =    $request->efin;
            // $proprietor->efin_password     =    $request->efin_password;
            $proprietor->tax_region        =    $request->taxRegion;
            // $proprietor->brelaORS          =    $request->brelaORS;
            $proprietor->CertofReg         =    $certRegName;
            $proprietor->CertExtr          =    $certExtrName;
            $proprietor->memart            =    $request->memart;
            $proprietor->CertRegDate       =    $request->CertRegDate;
            $proprietor->tax_file_location =    $request->tax_file_location;
            $proprietor->fiscal_yr         =    $request->fiscalYear;
            $proprietor->company_type      =    $request->compType;
            $proprietor->save();

            return redirect()->route('client.passwrd');
        }
    }

    /************* Create Client Partnership *******************/
    public function step3()
    {
        return view('client.partnership');
    }
    public function step3process(Request $request)
    {
        /*$fromForm = $request->validate([
            'name'           =>     '',
            'address1'       =>     '',
            'city'           =>     '',
            'phone_number'   =>     'numeric',
            'email'          =>     'email',
            'tin_number'     =>     '',
            'tinCert'        =>     'mimes:pdf',
            'certReg'        =>     'mimes:pdf',
            'certExtr'       =>     'mimes:pdf',
        ]);*/
        $tincertName = null;
        if ($request->hasFile('tinCert')) {
            $tincert = $request->file('tinCert');
            $tincertName = uniqid() . '.' . $tincert->getClientOriginalExtension();
            $tincert->storeAs('public/upload', $tincertName);
        }
        $certVatName = null;
        if ($request->hasFile('certVat')) {
            $certVat = $request->file('certVat');
            $certVatName = uniqid() . '.' . $certVat->getClientOriginalExtension();
            $certVat->storeAs('public/upload', $certVatName);
        }
        $certRegName = null;
        if ($request->hasFile('certReg')) {
            $certReg = $request->file('certReg');
            $certRegName =  uniqid() . '.' . $certReg->getClientOriginalExtension();
            $certReg->storeAs('public/upload', $certRegName);
        }
        $certExtrName = null;
        if ($request->hasFile('certExtr')) {
            $certExtr = $request->file('certExtr');
            $certExtrName =  uniqid() . '.' . $certExtr->getClientOriginalExtension();
            $certExtr->storeAs('public/upload', $certExtrName);
        }
        $partnershipDeedName = null;
        if ($request->hasFile('partnershipDeed')) {
            $partnershipDeed = $request->file('partnershipDeed');
            $partnershipDeedName =  uniqid() . '.' . $partnershipDeed->getClientOriginalExtension();
            $partnershipDeed->storeAs('public/upload', $partnershipDeedName);
        }
        $partner = new Client();
        $partner->name              =    $request->name;
        $partner->tradeas           =    $request->tradeas;
        $partner->address1          =    $request->address1;
        $partner->block             =    $request->block;
        $partner->plot              =    $request->plot;
        $partner->house             =    $request->house;
        $partner->city              =    $request->city;
        $partner->phone_number      =    $request->phone_number;
        $partner->email             =    $request->email;
        $partner->tin_number        =    $request->tin_number;
        $partner->tinCert           =    $tincertName;
        $partner->vrn               =    $request->vrn;
        $partner->certVat           =    $certVatName;
        //$partner->efin              =    $request->efin;
        //$partner->efin_password     =    $request->efin_password;
        $partner->tax_region        =    $request->taxRegion;
        // $partner->brelaORS          =    $request->brelaORS;
        $partner->CertofReg         =    $certRegName;
        $partner->CertRegDate       =    $request->CertRegDate;
        $partner->certExtr          =    $certExtrName;
        $partner->tax_file_location =    $request->tax_file_location;
        $partner->fiscal_yr         =    $request->fiscalYear;
        $partner->company_type       =    $request->compType;
        $partner->partnershipDeed    =    $partnershipDeedName;
        $partner->save();
        return redirect('/passwrd');
    }

    /************* Create Client Limited Company *******************/
    public function step4()
    {
        return view('client.limited');
    }
    public function step4process(Request $request)
    {
        /*$fromForm = $request->validate([
            'name'              =>     '',
            'address1'          =>     '',
            'city'              =>     '',
            'phone_number'      =>     '',
            'email'             =>     'email',
            'tin_number'        =>     '',
            'tinCert'           =>     'mimes:pdf',
            'certIncorporation' =>     'mimes:pdf',
            'memart'            =>     'mimes:pdf',
            'fiscalYear'        =>     '',
        ]);*/
        $tincertName = null;
        if ($request->hasFile('tinCert')) {
            $tincert = $request->file('tinCert');
            $tincertName = uniqid() . '.' . $tincert->getClientOriginalExtension();
            $tincert->storeAs('public/upload', $tincertName);
        }
        $certVatName = null;
        if ($request->hasFile('certVat')) {
            $certVat = $request->file('certVat');
            $certVatName =  uniqid() . '.' . $certVat->getClientOriginalExtension();
            $certVat->storeAs('public/upload', $certVatName);
        }
        $memartName = null;
        if ($request->hasFile('memart')) {
            $memart = $request->file('memart');
            $memartName =  uniqid() . '.' . $memart->getClientOriginalExtension();
            $memart->storeAs('public/upload', $memartName);
        }
        $certIncName = null;
        if ($request->hasFile('certIncorporation')) {
            $certInc = $request->file('certIncorporation');
            $certIncName =  uniqid() . '.' . $certInc->getClientOriginalExtension();
            $certInc->storeAs('public/upload', $certIncName);
        }

        $limited = new Client();
        $limited->name              =    $request->name;
        $limited->tradeas           =    $request->tradeas;
        $limited->address1          =    $request->address1;
        $limited->block             =    $request->block;
        $limited->plot              =    $request->plot;
        $limited->house             =    $request->house;
        $limited->city              =    $request->city;
        $limited->phone_number      =    $request->phone_number;
        $limited->email             =    $request->email;
        $limited->tin_number        =    $request->tin_number;
        $limited->tinCert           =    $tincertName;
        $limited->vrn               =    $request->vrn;
        $limited->certVat           =    $certVatName;
        //$limited->efin              =    $request->efin;
        //$limited->efin_password     =    $request->efin_password;
        $limited->tax_region        =    $request->taxRegion;
        //$limited->brelaORS          =    $request->brelaORS;
        $limited->CertRegDate       =    $request->CertRegDate;
        $limited->CertIncorp        =    $certIncName;
        $limited->memart            =    $memartName;
        $limited->fiscal_yr         =    $request->fiscalYear;
        $limited->company_type      =    $request->compType;
        $limited->paidup_share      =   $request->paidup_share;
        $limited->authorised_share  =   $request->authorised_share;

        $limited->save();
        return redirect('/passwrd')->with('clientname', 'name');
    }
    //************  Step to Edit Exiting Client  **************************//
    public function edit($id)
    {
        $client                 =  Client::find($id);
        $contactPer             =  ContactPerson::all();
        $assignContactPersonSP  =  ContactPersonSole::where('client_id', $id)->with('contactPersonSole')->get();
        $assignContactPerson    =  ContactPersonPartner::where('client_id', $id)->with('contactPersonPtr')->get();
        //$ContactPersonPartner   = cp_partners::where('client_id', $id)->with('cpPartner')->get();
        $assignContactPersonltd =  Client_ContactPerson::where('client_id', $id)->with('contactPerson')->get();
        //$shareholder            =  ContactPersonLimited::where('client_id', $id)->with('contactPersonltd')->get();
        $contactPersonltd       =  cp_limited::where('client_id', $id)->with('cpLimited')->get();
        $contactPersonPartner   =  cp_partners::where('client_id', $id)->with('contactPersonPartner')->get();
        $shareholder            = LimitedShareholder::where('client_id', $id)->with('contactPersonltd')->get();
        $director               = LimitedDirector::where('client_id', $id)->with('contactPersonltd')->get();

        $compType = $client->company_type;
        if ($compType == 'Sole Proprietor') {
            return view('client.soleproprietorupdate', compact('client', 'contactPer', 'assignContactPersonSP'));
        } elseif ($compType == 'Partnership') {
            return view('client.partnerupdate', compact('client', 'assignContactPerson', 'contactPer', 'assignContactPersonltd', 'contactPersonPartner'));
        } elseif ($compType == 'Limited') {
            return view('client.limitedupdate', compact('client', 'assignContactPersonltd', 'contactPer', 'shareholder', 'contactPersonltd', 'director'));
        } else {
            return redirect()->back();
        }
    }

    //*******  Update Solepropeator Company ***********//
    public function updateSole(Request $request, $id)
    {
        $sole = $request->validate([
            'clientname'     =>     'required',
            'address1'       =>     'required',
            'city'           =>     'required',
            'phone_number'   =>     'required',
            'email'          =>     'required|email',
            'tin_number'     =>     'required',

        ]);
        $proprietor = Client::find($id);

        if ($request->hasFile('tincert')) {
            $pdfFile = $request->file('tincert');
            $tincertName = uniqid() . '.' . $pdfFile->getClientOriginalExtension();
            $pdfFile->storeAs('public/upload', $tincertName);
            $proprietor->tinCert           =    $tincertName;
        }

        if ($request->hasFile('certReg')) {
            $certReg = $request->file('certReg');
            $certRegName =  uniqid() . '.' . $certReg->getClientOriginalExtension();
            $certReg->storeAs('public/upload', $certRegName);
            $proprietor->CertofReg         =    $certRegName;
        }

        if ($request->hasFile('certExtr')) {
            $certExtr = $request->file('certExtr');
            $certExtrName =  uniqid() . '.' . $certExtr->getClientOriginalExtension();
            $certExtr->storeAs('public/upload', $certExtrName);
            $proprietor->CertExtr          =    $certExtrName;
        }

        if ($request->hasFile('certVat')) {
            $certVat = $request->file('certVat');
            $certVatName =  uniqid() . '.' . $certVat->getClientOriginalExtension();
            $certVat->storeAs('public/upload', $certVatName);
            $proprietor->certVat           =    $certVatName;
        }
        if (!empty($request->fiscal_yr)) {
            $proprietor->fiscal_yr =  $request->input('fiscal_yr');
        }
        if (!empty($request->taxRegion)) {
            $proprietor->tax_region =  $request->input('taxRegion');
        }

        $proprietor->name              =    $request->clientname;
        $proprietor->tradeas           =    $request->tradeas;
        $proprietor->address1          =    $request->address1;
        $proprietor->block             =    $request->block;
        $proprietor->plot              =    $request->plot;
        $proprietor->house             =    $request->house;
        $proprietor->city              =    $request->city;
        $proprietor->phone_number      =    $request->phone_number;
        $proprietor->email             =    $request->email;
        $proprietor->tin_number        =    $request->tin_number;
        $proprietor->vrn               =    $request->vrn;
        $proprietor->efin              =    $request->efin;
        $proprietor->efin_password     =    $request->efin_password;
        $proprietor->brelaORS          =    $request->brelaORS;
        $proprietor->memart            =    $request->memart;
        $proprietor->CertRegDate       =    $request->CertRegDate;
        $proprietor->tax_file_location =    $request->tax_file_location;
        $proprietor->contactPerson_id  =    $request->contactPerson;

        $proprietor->update();
        return redirect()->back()->with('message', 'Changes saved successfully!');
    }

    //*******  Update Partnership  Company  ***********//
    public function updatePartner(Request $request, $id)
    {
        $fromForm = $request->validate([
            'name'           =>     'required',
            'address1'       =>     'required',
            'city'           =>     'required',
            'phone_number'   =>     'required',
            'email'          =>     'required|email',
            'tin_number'     =>     'required',
        ]);

        $partner = Client::find($id);

        if ($request->hasFile('tincert')) {
            $tincert = $request->file('tincert');
            $tincertName = uniqid() . '.' . $tincert->getClientOriginalExtension();
            $tincert->storeAs('public/upload', $tincertName);
            $partner->tincert           =    $tincertName;
        }

        if ($request->hasFile('certVat')) {
            $certVat = $request->file('certVat');
            $certVatName = uniqid() . '.' . $certVat->getClientOriginalExtension();
            $certVat->storeAs('public/upload', $certVatName);
            $partner->certVat          =    $certVatName;
        }

        if ($request->hasFile('certReg')) {
            $certReg = $request->file('certReg');
            $certRegName =  uniqid() . '.' . $certReg->getClientOriginalExtension();
            $certReg->storeAs('public/upload', $certRegName);
            $partner->CertofReg         =    $certRegName;
        }

        if ($request->hasFile('certExtr')) {
            $certExtr = $request->file('certExtr');
            $certExtrName =  uniqid() . '.' . $certExtr->getClientOriginalExtension();
            $certExtr->storeAs('public/upload', $certExtrName);
            $partner->CertExtr          =    $certExtrName;
        }

        if ($request->hasFile('partnershipDeed')) {
            $partnershipDeed = $request->file('partnershipDeed');
            $partnershipDeedName =  uniqid() . '.' . $partnershipDeed->getClientOriginalExtension();
            $partnershipDeed->storeAs('public/upload', $partnershipDeedName);
            $partner->partnershipDeed    =    $partnershipDeedName;
        }
        if (!empty($request->fiscal_yr)) {
            $partner->fiscal_yr =  $request->input('fiscal_yr');
        }
        if (!empty($request->taxRegion)) {
            $partner->tax_region =  $request->input('taxRegion');
        }

        $partner->name              =    $request->name;
        $partner->tradeas           =    $request->tradeas;
        $partner->address1          =    $request->address1;
        $partner->block             =    $request->block;
        $partner->plot              =    $request->plot;
        $partner->house             =    $request->house;
        $partner->city              =    $request->city;
        $partner->phone_number      =    $request->phone_number;
        $partner->email             =    $request->email;
        $partner->tin_number        =    $request->tin_number;
        $partner->vrn               =    $request->vrn;
        $partner->efin              =    $request->efin;
        $partner->efin_password     =    $request->efin_password;
        $partner->brelaORS          =    $request->brelaORS;
        $partner->memart            =    $request->memart;
        $partner->CertRegDate       =    $request->CertRegDate;
        $partner->tax_file_location =    $request->tax_file_location;
        $partner->contactPerson_id    =    $request->contactPerson;

        $partner->update();
        return redirect()->back()->with('message', 'Changes saved successfully!');
    }
    //*******  Update Client which is Limited  Company  ***********//
    public function updateLimited(Request $request, $id)
    {
        $limited = $request->validate([
            'name'           =>     'required',
            'address1'       =>     'required',
            'city'           =>     'required',
            'phone_number'   =>     'required',
            'email'          =>     'required|email',
            'tin_number'     =>     'required',
        ]);

        $limited = Client::find($id);

        if ($request->hasFile('tincert')) {
            $tincert     = $request->file('tincert');
            $tincertName = uniqid() . '.' . $tincert->getClientOriginalExtension();
            $tincert->storeAs('public/upload', $tincertName);
            $limited->tinCert           =    $tincertName;
        }
        if ($request->hasFile('certVat')) {
            $certVat     = $request->file('certVat');
            $certVatName = uniqid() . '.' . $certVat->getClientOriginalExtension();
            $certVat->storeAs('public/upload', $certVatName);
            $limited->certVat           =    $certVatName;
        }
        if ($request->hasFile('certIncorpo')) {
            $certIncorpo     = $request->file('certIncorpo');
            $certIncorpoName =  uniqid() . '.' . $certIncorpo->getClientOriginalExtension();
            $certIncorpo->storeAs('public/upload', $certIncorpoName);
            $limited->CertIncorp         =    $certIncorpoName;
        }
        if ($request->hasFile('memart')) {
            $memart     = $request->file('memart');
            $memartName =  uniqid() . '.' . $memart->getClientOriginalExtension();
            $memart->storeAs('public/upload', $memartName);
            $limited->memart          =    $memartName;
        }
        if (!empty($request->fiscal_yr)) {
            $limited->fiscal_yr =  $request->input('fiscal_yr');
        }
        if (!empty($request->taxRegion)) {
            $limited->tax_region =  $request->input('taxRegion');
        }


        $limited->name              =    $request->name;
        $limited->tradeas           =    $request->tradeas;
        $limited->address1          =    $request->address1;
        $limited->block             =    $request->block;
        $limited->plot              =    $request->plot;
        $limited->house             =    $request->house;
        $limited->city              =    $request->city;
        $limited->phone_number      =    $request->phone_number;
        $limited->email             =    $request->email;
        $limited->tin_number        =    $request->tin_number;
        $limited->vrn               =    $request->vrn;
        $limited->efin              =    $request->efin;
        $limited->efin_password     =    $request->efin_password;
        $limited->brelaORS          =    $request->brelaORS;
        $limited->CertRegDate       =    $request->CertRegDate;
        $limited->tax_file_location =    $request->tax_file_location;
        $limited->paidup_share      =    $request->paidup_share;
        $limited->paidup_total      =    $request->input('paidup_total');
        $limited->paidup_value      =    $request->input('paidup_value');
        $limited->authorised_share  =    $request->authorised_share;
        $limited->authorised_value  =    $request->authorised_value;
        $limited->authorised_total  =    $request->input('authorised_total');

        $limited->update();
        return redirect()->back()->with('message', 'Changes saved successfully!');
    }
    /*********** Assign Service to Client *****************/
    public function clientService($id)
    {
        $clients   = Client::find($id);
        $services  = Service::all();
        $servId    = Service::pluck('id');
        $clientServId    = ClientsService::pluck('services_id');
        $contpersonLtd   = ContactPersonLimited::where('client_id', '=', $id)->with('contactPersonltd')->get();
        $contpersonPtner = ContactPersonPartner::where('client_id', '=', $id)->with('contactPersonPtr')->get();
        $contactPerson   = ContactPersonSole::where('client_id', '=', $id)->with('contactPersonSole')->get();

        $result = DB::table('client_services')
            ->join('services', 'client_services.services_id', '=', 'services.id')
            ->select('client_services.*', 'services.service_name')
            ->where('client_services.clients_id', $id)
            ->get();

        $compType = $clients->company_type;
        if ($compType == 'Sole Proprietor') {
            return view('client.assignedService.assignservice.sole-proprietor', compact('clients', 'services', 'result', 'servId', 'clientServId', 'contactPerson'));
        } elseif ($compType == 'Partnership') {
            return view('client.assignedService.assignservice.partnership', compact('clients', 'services', 'result', 'servId', 'clientServId', 'contpersonPtner'));
        } elseif ($compType == 'Limited') {
            return view('client.assignedService.assignservice.limited', compact('clients', 'services', 'result', 'servId', 'clientServId', 'contpersonLtd'));
        } else {
            return redirect()->back();
        }

        return view('client.clientservice', compact('clients', 'services', 'result', 'servId', 'clientServId'));
    }
    /*public function assignService(Request $request)
    {
        $servSelected = $request->input('client_service');
        $client = $request->input('client');

        $servExist = DB::table('client_services')
            ->select('services_id')
            ->where('clients_id', '=', $client)
            ->get()
            ->pluck('services_id')
            ->toArray();

        $missingServices = array_diff($servSelected, $servExist);

        if (empty($missingServices)) {
            return redirect()->back()->with('error', 'All selected services already exist!');
        } else {
            foreach ($missingServices as $serv) {
                ClientsService::create([
                    'clients_id' => $client,
                    'services_id' => $serv
                ]);
            }
            return redirect()->back()->with('message', 'Successfully assigned new services!');
        }
    }*/
    public function assignService(Request $request)
    {
        $servSelected = $request->input('client_service');
        $client = $request->input('client');

        // ID of the default "ad-hoc" service
        $adHocServiceId = 3;  // Replace with the actual ID of the "ad-hoc service"

        // Ensure the "ad-hoc service" is always part of the assigned services
        if (!in_array($adHocServiceId, $servSelected)) {
            $servSelected[] = $adHocServiceId;
        }

        $servExist = DB::table('client_services')
            ->select('services_id')
            ->where('clients_id', '=', $client)
            ->get()
            ->pluck('services_id')
            ->toArray();

        $missingServices = array_diff($servSelected, $servExist);

        if (empty($missingServices)) {
            return redirect()->back()->with('error', 'All selected services already exist!');
        } else {
            foreach ($missingServices as $serv) {
                ClientsService::create([
                    'clients_id' => $client,
                    'services_id' => $serv
                ]);
            }
            return redirect()->back()->with('message', 'Successfully assigned new services!');
        }
    }

    public function assignServiceModal($id)
    {
        $clientServ = ClientsService::findOrFail($id);
        return response()->json($clientServ);
    }
    /************** End of Assign Service to Client ******************/
    public function getsole($id)
    {
        $clients = Client::with('clients')->find($id);
    }
    /************** Suspend the client*****************/
    public function suspendClient($id)
    {
        $susp = Client::find($id);
        $susp->status = "Inactive";
        $susp->update();
        return redirect()->back()->with('success', 'The client has been successfully Suspended!');
    }

    /************** Suspend the client*****************/
    public function reactivateClient($id)
    {
        $susp = Client::find($id);
        $susp->status = "Active";
        $susp->update();
        return redirect()->back()->with('success', 'The client has been successfully Reactivate!');
    }
    /************** View the client file that attached *****************/

    /************** Activate Pending Client To Active *************/
    public function activateClient($id)
    {
        $activate = Client::find($id);
        $activate->isNew = "No";
        $activate->update();
        return redirect()->route('client.clients');
    }
}
