<?php

namespace App\Http\Controllers;

use App\Models\Client;
use App\Models\Client_ContactPerson;
use App\Models\ContactPerson;
use App\Models\ContactPersonLimited;
use App\Models\ContactPersonPartner;
use App\Models\ContactPersonSole;
use App\Models\cp_limited;
use App\Models\cp_partners;
use App\Models\LimitedDirector;
use App\Models\LimitedShareholder;
use Dotenv\Validator as DotenvValidator;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Validator;

class ContactPersonController extends Controller
{

    public function ContactPersonList()
    {
        $contactPerson = ContactPerson::all();
        return view('client.contactperson.contactpersonlist', compact('contactPerson'));
    }

    public function addContactPerson()
    {
        $clientId = Client::latest('created_at')->first();
        return view('client.contactperson.createContactPerson', compact('clientId'));
    }

    /*public function store(Request $request)
    {
        $contact = $request->validate([
            'tin'           =>  'required',
            'tin_cert'      =>  'required',
            'nidacopy'      =>  'required'
        ]);
        if ($request->hasFile('passportcopy')) {
            $passportcopy = $request->file('passportcopy');
            $passportcopyName =  uniqid() . '.' . $passportcopy->getClientOriginalExtension();
            $passportcopy->storeAs('public/uploads', $passportcopyName);
        } else {
            $passportcopyName = null;
        }
        if ($request->hasFile('nidacopy')) {
            $nidacopy = $request->file('nidacopy');
            $nidacopyName =  uniqid() . '.' . $nidacopy->getClientOriginalExtension();
            $nidacopy->storeAs('public/uploads', $nidacopyName);
        }
        if ($request->hasFile('tin_cert')) {
            $tinCert = $request->file('tin_cert');
            $tinCertName =  uniqid() . '.' . $tinCert->getClientOriginalExtension();
            $tinCert->storeAs('public/uploads', $tinCertName);
        }

        $contactPerson = new ContactPerson();

        //$contactPerson->client_id     =    $request->clientId;
        $contactPerson->first_name      =    $request->first_name;
        $contactPerson->middle_name     =    $request->middle_name;
        $contactPerson->last_name       =    $request->last_name;
        //$contactPerson->position      =    $request->position;
        $contactPerson->phone           =    $request->phone;
        $contactPerson->email           =    $request->email;
        $contactPerson->tin             =    $request->tin;
        //$contactPerson->nationality   =    $request->nationality;
        //$contactPerson->director      =    $request->director;
        $contactPerson->radio           =    $request->radio;
        $contactPerson->passport        =    $request->passport;
        $contactPerson->passportcopy    =    $passportcopyName;
        $contactPerson->nida            =    $request->nida;
        $contactPerson->nidacopy        =    $nidacopyName;
        $contactPerson->tinCert         =    $tinCertName;

        $contactPerson->save();
        return redirect()->back()->with('message', 'Successfuly create new contact person!');
    }*/
    public function store(Request $request)
    {
        // Validate required fields
        $validatedData = $request->validate([
            'tin' => 'required',
            // 'tin_cert' => 'required|file', // Ensure 'tin_cert' is a valid file
            // 'nidacopy' => 'required|file', // Ensure 'nidacopy' is a valid file
            //'first_name' => 'required|string',
            // 'last_name' => 'required|string',
            //'phone' => 'required|string',
            //'email' => 'required|email',
        ]);

        // Function to handle file uploads
        $uploadFile = function ($file) {
            return $file ? $file->storeAs('public/upload', uniqid() . '.' . $file->getClientOriginalExtension()) : null;
        };

        // Upload files if they exist
        $passportCopyPath = $request->hasFile('passportcopy') ? $uploadFile($request->file('passportcopy')) : null;
        $nidaCopyPath = $uploadFile($request->file('nidacopy'));
        $tinCertPath = $uploadFile($request->file('tin_cert'));

        // Create a new ContactPerson instance
        $contactPerson = new ContactPerson();
        $contactPerson->first_name = $request->input('first_name');
        $contactPerson->middle_name = $request->input('middle_name', null); // Optional
        $contactPerson->last_name = $request->input('last_name');
        $contactPerson->phone = $request->input('phone');
        $contactPerson->email = $request->input('email');
        $contactPerson->tin = $validatedData['tin'];
        $contactPerson->radio = $request->input('radio', null); // Optional
        $contactPerson->passport = $request->input('passport', null); // Optional
        $contactPerson->passportcopy = $passportCopyPath;
        $contactPerson->nida = $request->input('nida', null); // Optional
        $contactPerson->nidacopy = $nidaCopyPath;
        $contactPerson->tinCert = $tinCertPath;

        // Save the ContactPerson record
        $contactPerson->save();

        // Redirect back with success message
        return redirect()->back()->with('message', 'Successfully created a new contact person!');
    }

    /******************* Add New Partner **********************/
    public function AssignContactPerson(Request $request)
    {
        // Validate request data
        $valide = $request->validate([
            'contactPerson' => 'required|string',
            'sharePercent' => 'required|numeric|min:0|max:100',
        ]);
        $existingShareholder = ContactPersonPartner::where('contactpeople_id', $request->input('contactPerson'))
            ->where('client_id', $request->input('client'))->first();

        if ($existingShareholder) {
            return redirect()->back()
                ->withErrors(['error' => 'The partner already exists.'])
                ->withInput();
        }

        // Check if adding the new percentage would exceed 100%
        $currentTotalPercent = ContactPersonPartner::where('client_id', $request->input('client'))->sum('share_percent');
        $newPercent = $request->input('sharePercent');

        if ($currentTotalPercent + $newPercent > 100) {
            return redirect()->back()
                ->withErrors(['error' => 'The total percentage cannot exceed 100%.'])
                ->withInput();
        }
        ContactPersonPartner::create([
            'contactpeople_id' => $request->input('contactPerson'),
            'share_percent'    => $newPercent,
            'client_id'        => $request->client,
        ]);

        return redirect()->back()->with('message', 'Partner added successfully!');
    }
    /********************** Edit Partner *******************/

    public function EditPartner(Request $request, $id)
    {
        // Validate request data
        $validated = $request->validate([
            'sharePercent' => 'required|numeric|min:0|max:100',
        ]);
        $partner = ContactPersonPartner::find($id);
        // Check if the partner exists
        if (!$partner) {
            return redirect()->back()
                ->withErrors(['error' => 'Partner not found.'])
                ->withInput();
        }
        // Check if updating the percentage would exceed 100%
        $currentTotalPercent = ContactPersonPartner::where('client_id', $partner->client_id)
            ->where('id', '!=', $id)
            ->sum('share_percent');
        $newPercent = $request->input('sharePercent');
        if ($currentTotalPercent + $newPercent > 100) {
            return redirect()->back()
                ->withErrors(['error' => 'The total percentage cannot exceed 100%.'])
                ->withInput();
        }
        // Update the partner data in the database
        $partner->update([
            'share_percent' => $newPercent,
        ]);

        return redirect()->back()->with('message', 'Partner updated successfully!');
    }

    /*****************  Assign Contact Person for Partner ************/
    public function ContactPersonPtr(Request $request)
    {
        $ptrPerson = cp_partners::where('contactperson_id', $request->input('contactPerson'))
            ->where('client_id', $request->input('client'))->first();
        if ($ptrPerson) {
            return redirect()->back()
                ->withErrors(['error' => 'The contact person already exists!'])
                ->withInput();
        }
        $contPerson = cp_partners::create([
            'client_id'         =>   $request->client,
            'contactperson_id'  =>   $request->contactPerson,
        ]);
        return redirect()->back()->with('message', 'Contact person added successfully!');
    }

    /******************Edit Contact Partner *****************/
    public function EditContactPartner(Request $request, $id)
    {
        $partnerPerson = Client_ContactPerson::find($id);
        $partnerPerson = $request->input('contactPerson');
        $partnerPerson->update();
        return redirect()->back()->with('message', 'Contact person updated Successfully');
    }
    /********************Delete Contact Person from Partner *******************/

    public function DeleteContactPartner(Request $request, $id)
    {
        $partnerPerson = cp_partners::find($id);
        if (!$partnerPerson) {
            abort(403, "Unauthorized Access");
        }
        $partnerPerson->delete();
        return redirect()->back()->with('message', 'Contact Person deleted successfully!');
    }
    /******************** Edit Sole Proprietor *************/
    public function EditContactPerson(Request $request, $id)
    {

        $contPerson = ContactPersonSole::find($id);
        if ($contPerson) {
            $contPerson->role = $request->input('role');
            $contPerson->update();
        }
        return redirect()->back()->with('message', 'Contact Person update successfully!');
    }
    /****************** Edit Shareholder ***************/
    public function EditContactshareholder(Request $request, $id)
    {

        $shareholder = ContactPersonLimited::find($id);

        $sumPaidUpShares = ContactPersonLimited::where('client_id', $request->input('client'))->sum('number_shares');
        $totalPaidShares = Client::where('id', $request->input('client'))->first();
        if ($sumPaidUpShares >= $totalPaidShares) {
            return redirect()->back()
                ->withErrors(['error' => 'Number shares should not exceed Paid-up!'])
                ->withInput();
        }

        if ($shareholder) {
            $shareholder->number_shares      =   $request->numberShare;
            $shareholder->share_percent      =   $request->shareholding;
            $shareholder->update();
        }
        return redirect()->back()->with('message', 'Contact Person update successfully!');
    }

    /******************* Delete Person limited **********/

    public function deletePersonLtd($id)
    {
        $person = cp_limited::find($id);
        if (empty($person)) {
            return redirect()->back()->with('error', 'User is not found!');
        }
        $person->delete();
        return redirect()->back()->with('message', 'Contact Person deleted successfully!');
    }

    public function editPersonLtd(Request $request, $id)
    {
        $person = cp_limited::find($id);
        $person->client_id         =   $request->client;
        $person->contactpeople_id  =   $request->contactPerson;
        $person->update();
        return redirect()->back()->with('message', 'Contact Person updated successfully!');
    }

    /******************* Add Share holder and Directors to Limited Company *****************/
    public function AssignContactPersonLimited(Request $request)
    {
        $existingHolder = cp_limited::where('contactperson_id', $request->input('contactPerson'))
            ->where('client_id', $request->input('client'))
            ->first();

        if ($existingHolder) {
            return redirect()->back()
                ->withErrors(['error' => 'The contact person already exists!'])
                ->withInput();
        }

        /*
        $sumPaidUpShares = ContactPersonLimited::sum('number_shares');
        $totalPaidShares = Client::where('id', $request->input('client'))->first();
        if ($sumPaidUpShares >= $totalPaidShares) {
            return redirect()->back()
                ->withErrors(['error' => 'Number shares should not exceed Paid-up!'])
                ->withInput();
        }*/

        $contactPerson = new cp_limited();
        $contactPerson->client_id         =   $request->client;
        $contactPerson->contactperson_id  =   $request->contactPerson;
        $contactPerson->save();
        return redirect()->back()->with('message', 'Contact person added successfully!');
    }

    public function addDirectorLimited(Request $request)
    {
        $existingDirector = LimitedDirector::where('contactpeople_id', $request->input('contactPerson'))
            ->where('client_id', $request->input('client'))->first();

        if ($existingDirector) {
            return redirect()->back()
                ->withErrors(['error' => 'Director already exists!'])
                ->withInput();
        }
        $contactPerson = new LimitedDirector();
        $contactPerson->client_id        =  $request->client;
        $contactPerson->contactpeople_id =  $request->contactPerson;
        $contactPerson->save();

        return redirect()->back()->with('message', 'Director created successfully!');
    }

    public function ShareholderLimited(Request $request)
    {
        // Check if the shareholder already exists
        $existingHolder = LimitedShareholder::where('contactpeople_id', $request->input('contactPerson'))
            ->where('client_id', $request->input('client'))->first();

        if ($existingHolder) {
            return redirect()->back()
                ->withErrors(['error' => 'The shareholder already exists!'])
                ->withInput();
        }
        // Calculate existing paid-up shares and check if the new sum exceeds paid-up shares limit
        $paidUpSharesExist = LimitedShareholder::where('client_id', $request->input('client'))
            ->sum('number_shares');

        $addedPaidupShare = $request->input('numberShare');
        $newSum = $paidUpSharesExist + $addedPaidupShare;

        $clientPaidupShares = Client::where('id', $request->input('client'))->value('paidup_share');
        //return response()->json($clientPaidupShares);
        if ($newSum > $clientPaidupShares) {
            return redirect()->back()
                ->withErrors(['error' => 'Number of shares should not exceed Paid-up shares limit!'])
                ->withInput();
        }
        // Create a new shareholder
        $contactPerson = new LimitedShareholder();
        $contactPerson->client_id = $request->client;
        $contactPerson->contactpeople_id = $request->contactPerson;
        //$contactPerson->position = 'shareholder';
        $contactPerson->number_shares = $request->numberShare;
        $contactPerson->share_percent = $request->shareholding;
        $contactPerson->save();

        return redirect()->back()->with('message', 'Shareholder was created successfully!');
    }
    public function RemoveDirectorLimited($id)
    {
        $director = LimitedDirector::find($id);
        if ($director == null) {
            return response()->json(['error' => "Record not found"], 404);
        }
        $director->delete();
        return redirect()->back()->with('message', 'Director was deleted successfully!');
    }
    public function RemoveShareholder($id)
    {
        $shareholder = LimitedShareholder::find($id);
        if ($shareholder == null) {
            return response()->json(['error' => "Record not found"], 404);
        }
        $shareholder->delete();
        return redirect()->back()->with('message', 'Shareholder was deleted successfully!');
    }

    /******************************** Add Contact Person for Sole Prop **********************************/
    public function setContactPersonSole(Request $request)
    {
        $existingContactPerson = ContactPersonSole::where('contactpeople_id', $request->input('contactPerson'))->first();

        if ($existingContactPerson) {
            return redirect()->back()
                ->withErrors(['error' => 'The contact person already exists!'])
                ->withInput();
        }
        $contPerson = ContactPersonSole::create([
            'client_id'         =>   $request->client,
            'contactpeople_id'  =>   $request->contactPerson,
            'role'              =>   $request->role,
        ]);
        return redirect()->back()->with('message', 'Contact person added successfully!');
    }
    /******************************** Delete Contact Person for Sole Prop **********************************/
    public function deleteContactPersonSole($id)
    {
        $solePerson = ContactPersonSole::find($id);
        if ($solePerson == null) {
            return response()->json(['error' => "Record not found"], 404);
        }
        $solePerson->delete();
        return redirect()->back()->with('message', 'Contact Person deleted successfully!');
    }

    /******************************** Delete Partner for Partnership **********************************/
    public function deleteContactPersonPtnr($id)
    {
        $partner = ContactPersonPartner::find($id);
        if ($partner == null) {
            return response()->json(['error' => "Record not found"], 404);
        }
        $partner->delete();
        return redirect()->back()->with('message', 'Contact person deleted successfully!');
    }

    /******************************** Delete Partner for Partnership **********************************/
    public function deleteContactltd($id)
    {
        $limited = ContactPersonLimited::find($id);
        if ($limited == null) {
            return redirect()->back()->with('error', 'Shareholder not found!');
        }
        $limited->delete();
        return redirect()->back()->with('message', 'Shareholder deleted successfully!');
    }

    /*public function limitedassigncontact()
    {
        $limitedContPer = ContactPersonLimited::all();
        return view('client.limitedupdate', compact('limitedContPer'));
    }*/
    public function DeleteAssignedContactPerson($id)
    {
        $deleteContactPerson = ContactPersonPartner::find($id);
        $deleteContactPerson->delete();
        return redirect()->back()->with('message', '');
    }
    /**************  View Contact Person *************/
    public function viewContactPerson($id)
    {
        $contactPerson = ContactPerson::find($id);

        //$companyltd    = ContactPersonLimited::with('Assigneduser')->where('contactpeople_id', $contactPerson->id)->pluck('client_id');
        //$companyPtner    = ContactPersonPartner::with('contactPersonPtr')->where('contactpeople_id', $contactPerson->id)->pluck('client_id');
        //$companysole    = ContactPersonSole::with('contactPersonSole')->where('contactpeople_id', $contactPerson->id)->pluck('client_id');
        //$companyCpltd    = cp_limited::with('cpLimited')->where('contactperson_id', $contactPerson->id)->pluck('client_id');
        //$companyCptner    = cp_partners::with('contactPersonPartner')->where('contactperson_id', $contactPerson->id)->pluck('client_id');

        $companysole = Client::whereIn('id', ContactPersonSole::where('contactpeople_id', $contactPerson->id)->pluck('client_id'))->pluck('name');
        $companyCpltd = Client::whereIn('id', cp_limited::where('contactperson_id', $contactPerson->id)->pluck('client_id'))->pluck('name');
        $companyCptner = Client::whereIn('id', cp_partners::where('contactperson_id', $contactPerson->id)->pluck('client_id'))->pluck('name');

        return view('client.contactperson.viewprofile', compact('contactPerson', 'companysole', 'companyCpltd', 'companyCptner'));
    }

    /****************** Edit Contant Person ***************/
    public function ContactDetailEdit($id)
    {
        $editPerson  =  ContactPerson::find($id);
        return view('client.contactperson.editprofile', compact('editPerson'));
    }
    /********************** Save Contact  ***************/

    public function ContactDetailEditData(Request $request, $id)
    {
        $data = ContactPerson::find($id);
        if ($request->hasFile('passportcopy')) {
            $passportcopy = $request->file('passportcopy');
            $passportcopyName =  uniqid() . '.' . $passportcopy->getClientOriginalExtension();
            $passportcopy->storeAs('public/uploads', $passportcopyName);
            $data->passportcopy    =    $passportcopyName;
        }
        if ($request->hasFile('nidacopy')) {
            $nidacopy = $request->file('nidacopy');
            $nidacopyName =  uniqid() . '.' . $nidacopy->getClientOriginalExtension();
            $nidacopy->storeAs('public/uploads', $nidacopyName);
            $data->nidacopy        =    $nidacopyName;
        }
        if ($request->hasFile('tin_cert')) {
            $tinCert = $request->file('tin_cert');
            $tinCertName =  uniqid() . '.' . $tinCert->getClientOriginalExtension();
            $tinCert->storeAs('public/uploads', $tinCertName);
            $data->tinCert         =    $tinCertName;
        }
        $data->first_name      =    $request->first_name;
        $data->middle_name     =    $request->middle_name;
        $data->last_name       =    $request->last_name;
        $data->phone           =    $request->phone;
        $data->email           =    $request->email;
        $data->tin             =    $request->tin;
        $data->radio           =    $request->radio;
        $data->passport        =    $request->passport;
        $data->nida            =    $request->nida;
        $data->update();
        return redirect()->back()->with('message', 'Changes are updated successfully!');
    }
    public function ContactDetailDelete($id)
    {
        $item = ContactPerson::find($id);
        if (!empty($item)) {
            $item->contactPersonlmtd()->delete();
            $item->cpLimitedperson()->delete();
            $item->delete();
            return redirect()->route('client.ContactPersonList');
        } else {
            return redirect()->route('client.ContactPersonList');
        }
    }
}
