<?php

namespace App\Http\Controllers;

use App\Models\Client;
use App\Models\CustomDispatchJob;
use App\Models\DispatchJob;
use App\Models\DocumentDispatchJob;
use App\Models\RecieveDoc;
use Barryvdh\DomPDF\PDF;
use Illuminate\Http\Request;

class DispatchJobController extends Controller
{
    public function listdispatch()
    {
        $dispatch = DocumentDispatchJob::all();
        return view('dispatch.dispatchdoc', compact('dispatch'));
    }
    public function dispCreate()
    {
        $clients = Client::all();
        $DocsReceived = RecieveDoc::with('clientRecieveDoc')->get();
        return view('dispatch.createDispatch', compact('DocsReceived', 'clients'));
    }
    public function customDispatchCreate()
    {
        $custdispatch = CustomDispatchJob::all();
        return view('dispatch.customDispatchlist', compact('custdispatch'));
    }
    public function storedispatch(Request $request)
    {
        $dispatchdata = new DispatchJob();

        $dispatchdata->clients_id        =  $request->selected_client;
        $dispatchdata->dispatch_date     =  $request->dispatch_date;
        $dispatchdata->date_received     =  $request->date_doc_receive;
        $dispatchdata->description       =  $request->disp_doc_desc;
        $dispatchdata->Qty               =  $request->disp_doc_qty;
        $dispatchdata->checkout          =  $request->disp_doc_chckout;
        $dispatchdata->narration         =  $request->disp_doc_narration;
        $dispatchdata->custom_desc       =  $request->custom_desc;
        $dispatchdata->custom_check      =  $request->custom_check;
        $dispatchdata->custom_narration  =  $request->custom_narration;
        $dispatchdata->dispatch_note     =  $request->dispatch_note;
        $dispatchdata->dispatchCreator   =  $request->dispatchCreator;

        $dispatchdata->save();
        return view('dispatch.dispatchdoc');
    }
    public function viewdispatch($id)
    {
        # code...
    }
    public function DocsReceive(Request $request)
    {
        $docReceived = RecieveDoc::where('client_id', '=', $request->id)->get();
        if (count($docReceived) > 0) {
            return response()->json($docReceived);
        }
    }
    public function DispatchClient(Request $request)
    {
        $clientAddress = Client::where('id', '=', $request->id)->get();
        if (count($clientAddress) > 0) {
            return response()->json($clientAddress);
        }
    }
    public function dispCreateCustom()
    {
        $clients = Client::all();
        $DocsReceived = RecieveDoc::with('clientRecieveDoc')->get();
        return view('dispatch.customDispatch', compact('DocsReceived', 'clients'));
    }
}
