<?php

namespace App\Http\Controllers;

use App\Models\Client;
use App\Models\Employee;
use App\Models\Role_has_Permission;
use App\Models\Task_Comments;
use App\Models\Task_Post;
use App\Models\Tasks;
use App\Http\Controllers\Storage;
use App\Models\CheckInTime;
use App\Models\CheckOutTime;
use App\Models\KPI_Tracker;
use App\Models\KPIPerfomance;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Storage as FacadesStorage;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Traits\HasPermissions;


class HomeController extends Controller
{
    use HasPermissions;
    /*
    *
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */

    public function kpiTracker()
    {
        $userId = Auth::user()->id;
        $tasks = Tasks::where('user_id', $userId)->get();

        if ($tasks->isEmpty()) {
            return response()->json(['error' => 'No tasks found for this user'], 404);
        }
        foreach ($tasks as $task) {
            if ($task->post_approval === 'yes') {
                continue; // Move to the next task
            }
            $dueDate = Carbon::parse($task->end_date);
            $completionDate = now();
            // Determine KPI points
            if ($completionDate->lt($dueDate)) {
                $kpiPoints = 1;  // Completed before due date
            } elseif ($completionDate->eq($dueDate)) {
                $kpiPoints = 0;  // Completed on due date
            } else {
                $kpiPoints = -1; // Completed after due date
            }

            // Update or create KPI record
            KPIPerfomance::updateOrCreate(
                ['users_id' => $userId, 'tasks_id' => $task->id],
                ['kpi_points' => $kpiPoints, 'updated_at' => now()]
            );
        }

        return response()->json([
            'message' => 'KPI updated successfully for all eligible tasks',
        ]);
    }
    public function index()
    {
        $totalEmployees = Employee::count();
        $totalTask      = Tasks::count();
        $totalClients   = Client::count();
        $roleId         = Auth::user()->role_id;
        $all_perm       = Role::find($roleId)->permissions;
        $role           = Role::find($roleId);
        $comments       = Task_Post::count();
        $userId         =  Auth::user()->id;
        $kpiPoint     = KPIPerfomance::where('users_id', $userId)->pluck('kpi_points')->toArray();
        //$latePoint      = KPI_Tracker::where('users_id', $userId)->pluck('kpi_late_point')->toArray();
        $totalPoint = array_sum($kpiPoint);
        //$totalKpiPoint      = $earlyTotalPoint + $lateTotalPoint;
        //$notifs = $comments->merge($posts);
        /*if ($role->hasPermissionTo('client-view')) {
            echo 'Yes';
        }*/
        if ($roleId === 1) {
            $totalEmployees = Employee::count();
            $totalTask      = Tasks::count();
            $totalClients   = Client::count();
            $roleId = Auth::user()->role_id;
            $all_perm = Role::find($roleId)->permissions;
            $role = Role::find($roleId);
            $comments = Task_Post::count();
            return view('home.index', compact(['totalClients', 'totalEmployees', 'totalTask', 'all_perm', 'comments']))->with('notify', 'hello');
        }
        $currentUser = Auth::user();
        //return response()->json($totalKpiPoint);
        return view('home.employee_dashboard', compact(['totalClients', 'totalEmployees', 'totalTask', 'all_perm', 'comments', 'totalPoint']))->with('notify', 'hello');
    }
    public function services()
    {
        return view('service.services');
    }

    public function servicesCreate()
    {
        return view('service.servicesCreate');
    }

    public function reports()
    {
        return view('month');
    }

    public function settings()
    {
        return view('general');
    }
    public function HeaderNotification() {}
    public function notify_message()
    {
        /*$userId = Auth::User()->id;
        $smsNotify =  Task_Comments::where('user_id',  $userId)->get();
        return view('notifications.messages', compact('smsNotify'));*/
        $userId = Auth::user()->id;
        $smsNotify = Task_Comments::where('user_id', $userId)->get();
        $unreadCount = $smsNotify->where('read', false)->count();
        return response()->json(['unreadCount' => $unreadCount]);
    }
    public function  commentCounter(Request $request)
    {
        $userRole = Auth::user()->role_id;
        $userId  = Auth::user()->id;
        if ($userRole < 2) {
            $count = Task_Comments::count();
            $comm  = Task_Comments::with('commentUser', 'user')
                ->where('user_id', $userId)
                ->orderBy('updated_at', 'asc')
                ->take(50)
                ->get();
            // return response()->json(['count' => $count, 'comm' => $comm]);
            echo $comm->user->profile_image;
        } else {
            $comm  = Task_Comments::with('commentUser', 'user')
                ->where('user_id', $userId)
                ->orderBy('updated_at', 'asc')
                ->take(50)
                ->get();
            $count = Task_Comments::where('user_id', $userId)->count();
            return response()->json(['count' => $count, 'comm' => $comm]);
        }
    }
    public function systemNotification(Request $request)
    {

        $system = Tasks::where('approve_status', '=', 'Approve')
            ->where('suspend_status', '=', 'Suspend')
            ->where('complete_status', '=', 'complete')->get();
        return response()->json($system);
    }

    /*public function notificationUpdate()
    {
        $commentNotify = Task_Comments::with('commentUser')->latest()->take(4)->get();
        $commentCount = Task_Comments::where('is_read', 0)->count();
        $postNotify = Task_Post::with('postuser')->latest()->take(4)->get();
        $postCount = Task_Post::where('is_read', 0)->count();

        return response()->json([
            'commentCount' => $commentCount,
            'comments' => $commentNotify->map(function ($comment) {
                return [
                    'username' => optional($comment->commentUser)->name,
                    'time' => $comment->created_at->diffForHumans(),
                    'comment' => $comment->comments,
                    'avatar' => optional($comment->commentUser)->profile_image
                        ? asset('storage/images/' . optional($comment->commentUser)->profile_image)
                        : asset('storage/images/Avatar.png'),
                ];
            }),
        ]);
    }*/
    public function notificationUpdate()
    {
        $commentCount = Task_Comments::where('is_read', false)->count();
        $commentNotify = Task_Comments::with('commentUser')
            ->where('is_read', false)
            ->latest()
            ->limit(5)
            ->get();

        $postNotify = Task_Post::with('postuser')->latest()->take(5)->get();
        $postCount = Task_Post::where('is_read', false)->count();

        // Format response data for comments
        $formattedComments = $commentNotify->map(function ($comment) {
            return [
                'username' => optional($comment->commentUser)->name ?? 'Unknown User',
                'time' => $comment->created_at->diffForHumans(),
                'taskId' => $comment->task_id,
                'commentId' => $comment->id,
                'comment' => $comment->comments,
                'avatar' => optional($comment->commentUser)->profile_image
                    ? asset('storage/images/' . optional($comment->commentUser)->profile_image)
                    : asset('storage/images/Avatar.png'),
            ];
        });

        // Format response data for posts
        $formattedPosts = $postNotify->map(function ($post) {
            return [
                'username' => optional($post->postuser)->name ?? 'Unknown User',
                'time' => $post->created_at->diffForHumans(),
                'content' => $post->post ?? 'No content available',
                'avatar' => optional($post->postuser)->profile_image
                    ? asset('storage/images/' . optional($post->postuser)->profile_image)
                    : asset('storage/images/Avatar.png'),
            ];
        });

        return response()->json([
            'commentCount' => $commentCount,
            'comments' => $formattedComments,
            'postCount' => $postCount,
            'posts' => $formattedPosts,
        ]);
    }
    /*
    public function notificationUpdate()
    {
        // Fetch latest 4 unread comments and count unread comments
        $commentNotify = Task_Comments::with('commentUser')->latest()->take(4)->get();
        $commentCount = Task_Comments::where('is_read', false)->count();

        // Fetch latest 4 unread posts and count unread posts
        $postNotify = Task_Post::with('postuser')->latest()->take(4)->get();
        $postCount = Task_Post::where('is_read', false)->count();

        // Combine comments and posts into a single collection
        $notifications = collect();

        // Format and add comments to notifications
        foreach ($commentNotify as $comment) {
            $notifications->push([
                'type' => 'comment',
                'username' => optional($comment->commentUser)->name ?? 'Unknown User',
                'time' => $comment->created_at->diffForHumans(),
                'comments' => $comment->comments,

                'avatar' => optional($comment->commentUser)->profile_image
                    ? asset('storage/images/' . optional($comment->commentUser)->profile_image)
                    : asset('storage/images/Avatar.png'),
            ]);
        }

        // Format and add posts to notifications
        foreach ($postNotify as $post) {
            $notifications->push([
                'type' => 'post',
                'username' => optional($post->postuser)->name ?? 'Unknown User',
                'time' => $post->created_at->diffForHumans(),
                'content' => $post->post ?? 'No content available',
                'avatar' => optional($post->postuser)->profile_image
                    ? asset('storage/images/' . optional($post->postuser)->profile_image)
                    : asset('storage/images/Avatar.png'),
            ]);
        }

        // Group notifications by user
        $groupedNotifications = $notifications->groupBy('username');

        return response()->json([
            'commentCount' => $commentCount,
            'postCount' => $postCount,
            'notifications' => $groupedNotifications,
        ]);
    }*/
    public function taskNotification()
    {
        $taskNotify = Tasks::with('client')->where('is_read', false)->latest()->limit(5)->get();
        $taskCount  = Tasks::where('is_read', false)->count();

        if ($taskCount) {
            //$step1 = $taskCount->
        }
        return response()->json([
            'taskCount' => $taskCount,
            'taskNotify' => $taskNotify
        ]);
    }
    public function taskNotificationDelete($id)
    {
        $taskNotify = Tasks::find($id);
        $taskNotify->is_read = true;
        $taskNotify->save();
        return response()->json(['message' => 'Task read successfully']);
    }

    public function commentDelete($id)
    {
        $comment = Task_Comments::find($id);

        if ($comment) {
            $comment->is_read = true; // Use boolean true instead of string 'true'
            $comment->save(); // Use save() instead of update() for single model instance
            return response()->json(['message' => 'Comment marked as read successfully']);
        }

        return response()->json(['message' => 'Comment not found'], 404);
    }

    public function showNotification()
    {
        $unreadComm = Task_Comments::with('commentUser')->get();
        return response()->json(['unreadComm' => $unreadComm,]);
    }
    //*********** Punch In  ***************//

    public function punchInBtn(Request $request)
    {
        try {
            // Ensure the user is authenticated
            if (!Auth::check()) {
                return response()->json([
                    'success' => false,
                    'message' => 'Unauthorized access!',
                ], 403);
            }
            $userId = Auth::id();

            $alreadyCheckedIn = CheckInTime::where('user_id', $userId)
                ->whereDate('checked_in_time', now()->toDateString())
                ->exists();

            if ($alreadyCheckedIn) {
                return response()->json([
                    'success' => false,
                    'message' => 'You have already punched in today!',
                ], 400);
            }

            // Create the punch-in record
            $attendance = CheckInTime::create([
                'user_id' => $userId,
                'checked_in_time' => now(),
            ]);

            return response()->json([
                'success' => true,
                'message' => 'Punch in successful!',
            ], 200);
        } catch (\Exception $e) {
            // Log the error for debugging
            Log::error('Punch-in error: ' . $e->getMessage());

            return response()->json([
                'success' => false,
                'message' => 'Punch in failed! Please try again.',
            ], 500);
        }
    }

    //*********** Punch Out  ***************//
    public function punchOut(Request $request)
    {
        try {
            // Ensure the user is authenticated
            if (!Auth::check()) {
                return response()->json([
                    'success' => false,
                    'message' => 'Unauthorized access!',
                ], 403);
            }
            $userId = Auth::id(); // Get the authenticated user's ID
            $alreadyCheckedOut = CheckOutTime::where('user_id', $userId)
                ->whereDate('checked_out_time', now()->toDateString())
                ->exists();

            if ($alreadyCheckedOut) {
                return response()->json([
                    'success' => false,
                    'message' => 'You have already punched in today!',
                ], 400);
            }
            // Create the punch-in record
            $attendance = CheckOutTime::create([
                'user_id' => $userId,
                'checked_out_time' => now(),
            ]);

            return response()->json([
                'success' => true,
                'message' => 'Punch Out successful!',
            ], 200);
        } catch (\Exception $e) {
            // Log the error for debugging
            Log::error('Punch-out error: ' . $e->getMessage());

            return response()->json([
                'success' => false,
                'message' => 'Punch Out failed! Please try again.',
            ], 500);
        }
    }
}
