<?php

namespace App\Http\Controllers;

use App\Models\Attendance;
use App\Models\CheckInTime;
use App\Models\CheckOutTime;
use App\Models\LeaveRequest;
use App\Models\User;
use DateTime;
use Illuminate\Auth\Events\Validated;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class HrmController extends Controller
{
    public function attendanceIndex()
    {
        $employees = User::all();
        return view('hrm.attendance', compact('employees'));
    }
    public function attendanceList()
    {
        $result = Attendance::with('employeeAtt')->get();
        //$checkin = CheckInTime::with('employeeAtt')->get();
        //$checkout = CheckOutTime::with('employeeAtt')->get();
        $attendance = CheckInTime::with(['employeeAtt', 'checkOutTime'])
            ->get();
        //return response()->json($result);
        return view('hrm.attendancelist', compact('attendance'));
    }
    public function leaveRequestIndex()
    {
        return view('hrm.leaverequest');
    }
    public function leaveRequestData(Request $request)
    {
        $newRequest = $request->validate([
            'userId'  => 'required',
            'dateFrom' => 'required',
            'dateTo'   => 'required',
            'requestType' => 'required'
        ]);

        LeaveRequest::create([
            'user_id'      => Auth::user()->id,
            'dateFrom'     => $request->dateFrom,
            'dateTo'       => $request->dateTo,
            'request_type' => $request->requestType,
            //'status'     => 'Active',
        ]);
        return redirect()->back()->with('message', 'Request sent successfully! Wait for approval from the admin.');

        //return response()->json($newRequest);
    }

    public function leaveRequestList()
    {
        //$reqLeave = LeaveRequest::where('request_type', 'Annual')->get();
        $req = LeaveRequest::all();
        //$req = LeaveRequest::with('userRequest')->get();
        return view('hrm.requestlist', compact('req'));
    }

    public function RequestListEmployee()
    {
        $id = Auth::user()->id;
        $requests = LeaveRequest::where('user_id', '=', $id)->get();
        return view('hrm.requestlistemployee', compact('requests'));
    }
    public function leaveRequestApproval($id)
    {
        $leave = LeaveRequest::find($id);
        $leave->status = 'Approved';
        $leave->update();

        return redirect()->back()->with('message', 'Request approved successfully!');
    }
    public function leaveRequestDenied($id)
    {
        $leave = LeaveRequest::find($id);
        $leave->status = 'Disapproved';
        $leave->update();

        return redirect()->back()->with('message', 'Request approved successfully!');
    }
    public function ChechInTime(Request $request)
    {
        $checkin = new CheckInTime();
        $checkin->chechin_time = $request->checkintime;
        $checkin->checkin_date = $request->checkindate;
        $checkin->user_id      = $request->employee;


        return redirect()->back()->with('message', 'Attendance added successfully!');
    }
    public function CreateAttendencaList(Request $request)
    {
        $employees = User::all();
        return view('hrm.attendancecreate', compact('employees'));
    }
    public function CreateAttendenceForm(Request $request)
    {
        /* $attandenceData = $request->all();
        //$attendanceDate = $request->attandaceDate;

        $count = count($attandenceData['userId']);
        for ($i = 0; $i < $count; $i++) {
            Attendance::create([
                'user_id' => $attandenceData['userId'][$i],
                'checked_in_time' => $attandenceData['timeIn'][$i],
                'checked_out_time' => $attandenceData['timeOut'][$i],
                'attendance_date' => $attandenceData['attandaceDate'],
            ]);
        }
        return redirect()->back()->with('message', 'Attendance Added Successfully!');*/
        $request->validate([
            'attandaceDate' => 'required|date',
            'timeIn.*' => 'required|date_format:h:i A',
            'timeOut.*' => 'required|date_format:h:i A',
        ]);

        // Retrieve the attendance date
        $attendanceDate = $request->input('attandaceDate');

        // Retrieve the user IDs, timeIn, and timeOut arrays
        $userIds = $request->input('userId');
        $timeIn = $request->input('timeIn');
        $timeOut = $request->input('timeOut');

        // Loop through each user and save their attendance
        foreach ($userIds as $key => $userId) {
            Attendance::create([
                'user_id' => $userId,
                'checked_in_time' => $timeIn[$key],
                'checked_out_time' => $timeOut[$key],
                'attendance_date' => $attendanceDate,
            ]);
        }
    }
}
