<?php

namespace App\Http\Controllers;

use App\Models\CustomDispatchJob;
use App\Models\DispatchJob;
use App\Models\DocumentDispatchJob;
use App\Models\GeneralSetting;
use App\Models\RecieveDoc;
use Barryvdh\DomPDF\Facade\Pdf;
use Barryvdh\DomPDF\PDF as DomPDFPDF;
use Illuminate\Contracts\Session\Session as SessionSession;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use Symfony\Component\HttpFoundation\Session\Session;

class PDFController extends Controller
{
    public function generate()
    {
        $data = [
            'title' => 'Mars',
            'content' => 'Sample PDF content goes here.',
        ];

        $pdf = app('dompdf.wrapper')->loadView('pdf/sample', $data);
        //return $pdf->stream('document.pdf');
        return $pdf->download('document.pdf');
    }
    public function generatedispatch()
    {
    }
    public function DispatchPDF(Request $request)
    {
        $logo           = GeneralSetting::pluck('logo')->first();
        $uniqueName     = 'dispatchDocs_' . uniqid() . '.pdf';
        $lastDispatchJob = DocumentDispatchJob::latest('dispatch_no')->first(); // Get the latest DispatchJob record
        if ($lastDispatchJob) {
            $lastNumber = intval(substr($lastDispatchJob->dispatch_no, 1));
            $dispatchNumber = 'D' . str_pad($lastNumber + 1, 4, '0', STR_PAD_LEFT);
        } else {
            // If no DispatchJob exists yet, start with C0001
            $dispatchNumber = 'D0001';
        }

        $pdf = app('dompdf.wrapper')->loadView('pdf/dispatchDocs', [
            'logo'                =>   $logo,
            'dispatch_number'     =>   $dispatchNumber,
            'client_name'         =>   $request->input('selected_client'),
            'client_address'      =>   $request->input('client_address'),
            'dispatch_date'       =>   $request->input('date_of_disp'),
            'date_doc_receive'    =>   $request->input('date_doc_receive'),
            'disp_doc_desc'       =>   $request->input('disp_doc_desc'),
            'disp_doc_qty'        =>   $request->input('disp_doc_qty'),
            'disp_doc_chckout'    =>   $request->input('disp_doc_chckout'),
            'disp_doc_narration'  =>   $request->input('disp_doc_narration'),
            /*'cust_disp_desc'    =>   $request->input('cust_disp_desc'),
            'cust_disp_checkout'  =>   $request->input('cust_disp_checkout'),
            'cust_disp_narration' =>   $request->input('cust_disp_narration'),*/
            'disp_note'           =>   $request->input('disp_note')
        ]);

        $checkOutQty = $request->disp_doc_chckout;
        $taskId      = $request->dispatchTask;
        $serviceId   = $request->dispatchService;
        $receiveDocs = RecieveDoc::where('task_id', $taskId)
            ->where('service_id', $serviceId)
            ->get();

        foreach ($receiveDocs as $index => $receiveDoc) {
            $newQuantity = $receiveDoc->quantity - $checkOutQty[$index];
            $receiveDoc->quantity = $newQuantity;
            $receiveDoc->save();
        }

        Storage::put('public/dispatch/' . $uniqueName, $pdf->output());
        $document = new DocumentDispatchJob();
        $document->client_name         =  $request->input('selected_client');
        $document->dispatchCreator     =  $request->input('dispatchCreator');
        $document->dispatch_attachment =  $uniqueName;
        $document->dispatch_no         =  $dispatchNumber;
        $document->save();

        return $pdf->stream('dispatchDocs.pdf');
    }
    //Custom dispatch
    public function customDispatchPDF(Request $request)
    {
        $logo           = GeneralSetting::pluck('logo')->first();
        $uniqueName     = 'dispatchDocs_' . uniqid() . '.pdf';
        $lastDispatchJob = CustomDispatchJob::latest('dispatch_no')->first(); // Get the latest DispatchJob record
        if ($lastDispatchJob) {
            $lastNumber = intval(substr($lastDispatchJob->dispatch_no, 1));
            $dispatchNumber = 'C' . str_pad($lastNumber + 1, 4, '0', STR_PAD_LEFT);
        } else {
            // If no DispatchJob exists yet, start with C0001
            $dispatchNumber = 'C0001';
        }

        $pdf = app('dompdf.wrapper')->loadView('pdf/customDispatchPDF', [
            'logo'                =>   $logo,
            'dispatch_number'     =>   $dispatchNumber,
            'client_name'         =>   $request->input('selected_client'),
            'client_address'      =>   $request->input('client_address'),
            'dispatch_date'       =>   $request->input('date_of_disp'),
            /*'date_doc_receive'  =>   $request->input('date_doc_receive'),
            'disp_doc_desc'       =>   $request->input('disp_doc_desc'),
            'disp_doc_qty'        =>   $request->input('disp_doc_qty'),
            'disp_doc_chckout'    =>   $request->input('disp_doc_chckout'),
            'disp_doc_narration'  =>   $request->input('disp_doc_narration'),*/
            'cust_disp_desc'      =>   $request->input('cust_disp_desc'),
            'cust_disp_checkout'  =>   $request->input('cust_disp_checkout'),
            'cust_disp_narration' =>   $request->input('cust_disp_narration'),
            'disp_note'           =>   $request->input('disp_note')
        ]);

        $checkOutQty = $request->disp_doc_chckout;
        $taskId      = $request->dispatchTask;
        $serviceId   = $request->dispatchService;
        $receiveDocs = RecieveDoc::where('task_id', $taskId)
            ->where('service_id', $serviceId)
            ->get();

        foreach ($receiveDocs as $index => $receiveDoc) {
            $newQuantity = $receiveDoc->quantity - $checkOutQty[$index];
            $receiveDoc->quantity = $newQuantity;
            $receiveDoc->save();
        }

        Storage::put('public/customDispatch/' . $uniqueName, $pdf->output());
        $document = new CustomDispatchJob();
        $document->client_name         =  $request->input('selected_client');
        $document->dispatchCreator     =  $request->input('dispatchCreator');
        $document->dispatch_attachment =  $uniqueName;
        $document->dispatch_no         =  $request->$dispatchNumber;
        $document->save();

        return $pdf->stream('customDispatch.pdf');
        //return response()->json(['success' => true, 'pdf_url' => route('view_pdf', ['filename' => $uniqueName])]);
    }
    public function viewPdf()
    {
        // return view('pdf.dispatchDocs', compact(''));
    }
}
