<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class RegController extends Controller
{
    /*public function create(Request $request)
    {
        $username = $request->input('name');
        /*$request->validate([
            'name'     => 'required|string|max:255',
            'email'    => 'required|string|email|max:255|unique:users',
            'password' => 'required|min:6|confirmed',
        ]);
        $imageName = null;
        if ($request->hasFile('images')) {
            $image = $request->file('images');
            $imageName = time() . '.' . $image->getClientOriginalExtension();
            $image->storeAs('public/images', $imageName);
        }
        $cvDoc = null;
        if ($request->hasFile('cv')) {
            $cv = $request->file('cv');
            $cvDoc = uniqid() . '.' . $cv->getClientOriginalExtension();
            $cv->storeAs('public/upload', $cvDoc);
        }
        $contractDoc = null;
        if ($request->hasFile('contract')) {
            $contract = $request->file('contract');
            $contractDoc = uniqid() . '.' . $contract->getClientOriginalExtension();
            $contract->storeAs('public/upload', $contractDoc);
        }
        $applicationDoc = null;
        if ($request->hasFile('application')) {
            $application = $request->file('application');
            $applicationDoc = uniqid() . '.' . $application->getClientOriginalExtension();
            $application->storeAs('public/upload', $applicationDoc);
        }
        /* $offerletterDoc = null;
        if ($request->hasFile('offerletter')) {
            $offer_letter = $request->file('offerletter');
            $offerletterDoc = uniqid() . '.' . $offer_letter->getClientOriginalExtension();
            $offer_letter->storeAs('public/upload', $offerletterDoc);
        }

        if ($request->input('role_id') === '1') {

            User::create([
                'name'          =>   $request->input('name'),
                'email'         =>   $request->input('email'),
                'phone'             =>   $request->input('phone'),
                'password'      =>   Hash::make($request->input('password')),
                'role_id'       =>   $request->input('role_id'),
                'profile_image' =>   $imageName
            ]);
            return redirect()->back()->with('message', 'Admin created successfully!');
        } else {
            User::create([
                'name'              =>   $request->input('name'),
                'email'             =>   $request->input('email'),
                'password'          =>   Hash::make($request->input('password')),
                'role_id'           =>   $request->input('role_id'),
                'profile_image'     =>   $imageName,
                'first_name'        =>   $request->input('first_name'),
                'middle_name'       =>   $request->input('middle_name'),
                'last_name'         =>   $request->input('last_name'),
                'status'            =>   $request->input('status'),
                'position'          =>   $request->input('position'),
                'cv'                =>   $cvDoc,
                'contract'          =>   $contractDoc,
                'application'       =>   $applicationDoc,
                //'offer_letter'      =>   $offerletterDoc,
                'nssf'              =>   $request->input('nssf'),
                'enddate'           =>   $request->input('enddate'),
                'phone'             =>   $request->input('phone'),
                'joining_date'      =>   $request->input('joining_date'),
                'start_date'        =>   $request->input('start_date'),
                //'termination'       =>   $request->input('termination'),
                'termination_date'  =>   $request->input('termination_date'),
                'termination_letter' =>   $request->input('termination_letter'),
                'contract_period'   =>   $request->input('contract_period'),
                'tin'               =>   $request->input('tin'),
                'nida'              =>   $request->input('nida')
            ]);

            return redirect()->back()->with('message', 'User created successfully!');
        }
    }*/
    public function createUser(Request $request)
    {
        $request->validate([
            'name'     => 'required|string|max:255',
            'email'    => 'required|string|email|max:255|unique:users',
            //'password' => 'required|min:6|confirmed',
        ]);

        $imageName = $this->handleFileUpload($request->file('images'), 'public/images');
        $cvDoc = $this->handleFileUpload($request->file('cv'), 'public/upload');
        $contractDoc = $this->handleFileUpload($request->file('contract'), 'public/upload');
        $applicationDoc = $this->handleFileUpload($request->file('application'), 'public/upload');

        $data = [
            'name'          => $request->input('name'),
            'phone'         => $request->input('phone'),
            'email'         => $request->input('email'),
            'password'      => Hash::make($request->input('password')),
            'role_id'       => $request->input('role_id'),
            'profile_image' => $imageName,
        ];

        if ($request->input('role_id') != 1) {
            $additionalData = [
                'first_name'        => $request->input('first_name'),
                'middle_name'       => $request->input('middle_name'),
                'last_name'         => $request->input('last_name'),
                'status'            => $request->input('status'),
                'position'          => $request->input('position'),
                'cv'                => $cvDoc,
                'contract'          => $contractDoc,
                'application'       => $applicationDoc,
                'nssf'              => $request->input('nssf'),
                'enddate'           => $request->input('enddate'),
                'phone'             => $request->input('phone'),
                'joining_date'      => $request->input('joining_date'),
                'start_date'        => $request->input('start_date'),
                'enddate'           => $request->input('end_date'),
                /// 'termination_letter' => $request->input('termination_letter'),
                /// 'contract_period'   => $request->input('contract_period'),
                'tin'               => $request->input('tin'),
                'nida'              => $request->input('nida')
            ];

            $data = array_merge($data, $additionalData);
        }

        User::create($data);

        $message = ($request->input('role_id') == 1) ? 'Admin created successfully!' : 'User created successfully!';
        return redirect()->back()->with('message', $message);
    }

    private function handleFileUpload($file, $path)
    {
        if ($file) {
            $filename = uniqid() . '.' . $file->getClientOriginalExtension();
            $file->storeAs($path, $filename);
            return $filename;
        }
        return null;
    }

    public function createUp(Request $request)
    {
        // Validation rules
        $request->validate([
            'name'     => 'required|string|max:255',
            'email'    => 'required|string|email|max:255|unique:users',
            'role_id'  => 'required|integer',
            'phone'    => 'required|string',
            'images'   => 'nullable|image|mimes:jpeg,png,jpg|max:2048',
            'joining_date' => 'required|date',
            'position' => 'required|string',
            'tin'      => 'nullable|string',
            'nida'     => 'nullable|string',
            'nssf'     => 'nullable|string',
            'status'   => 'required|string',
        ]);

        // Handle file uploads
        $imageName = $request->hasFile('images')
            ? time() . '.' . $request->file('images')->getClientOriginalExtension()
            : null;

        $cvDoc = $request->hasFile('cv')
            ? uniqid() . '.' . $request->file('cv')->getClientOriginalExtension()
            : null;

        $contractDoc = $request->hasFile('contract')
            ? uniqid() . '.' . $request->file('contract')->getClientOriginalExtension()
            : null;

        $applicationDoc = $request->hasFile('application')
            ? uniqid() . '.' . $request->file('application')->getClientOriginalExtension()
            : null;

        // Store files if uploaded
        if ($imageName) $request->file('images')->storeAs('public/images', $imageName);
        if ($cvDoc) $request->file('cv')->storeAs('public/upload', $cvDoc);
        if ($contractDoc) $request->file('contract')->storeAs('public/upload', $contractDoc);
        if ($applicationDoc) $request->file('application')->storeAs('public/upload', $applicationDoc);

        // Prepare user data
        $userData = [
            'name' => $request->input('name'),
            'email' => $request->input('email'),
            'password' => Hash::make($request->input('password')),
            'role_id' => $request->input('role_id'),
            'profile_image' => $imageName,
            'phone' => $request->input('phone'),
            'first_name' => $request->input('first_name'),
            'middle_name' => $request->input('middle_name'),
            'last_name' => $request->input('last_name'),
            'status' => $request->input('status'),
            'position' => $request->input('position'),
            'cv' => $cvDoc,
            'contract' => $contractDoc,
            'application' => $applicationDoc,
            'joining_date' => $request->input('joining_date'),
            'start_date' => $request->input('start_date'),
            'enddate' => $request->input('enddate'),
            'tin' => $request->input('tin'),
            'nida' => $request->input('nida'),
            'nssf' => $request->input('nssf'),
            'termination_date' => $request->input('termination_date'),
            'termination_letter' => $request->input('termination_letter'),
            'contract_period' => $request->input('contract_period'),
        ];

        // Create user
        User::create($userData);

        return redirect()->back()->with('message', 'User created successfully!');
    }
    public function Edit(Request $request, $id)
    {
        $request->validate([
            'name'     => 'required|string|max:255',
            'email'    => 'required|string|email|max:255|unique:users,email,' . $id,
            //'password' => 'required|min:8|confirmed',
            'role_id'  => 'required'
        ]);

        $user = User::find($id);

        if ($request->hasFile('images')) {
            $image     = $request->file('images');
            $imageName = time() . '.' . $image->getClientOriginalExtension();
            $image->storeAs('public/images', $imageName);
            $user->profile_image = $imageName;
        }

        if ($request->hasFile('cv')) {
            $cv    = $request->file('cv');
            $cvDoc = uniqid() . '.' . $cv->getClientOriginalExtension();
            $cv->storeAs('public/upload', $cvDoc);
            $user->cv  =   $cvDoc;
        }

        if ($request->hasFile('contract')) {
            $contract    = $request->file('contract');
            $contractDoc = uniqid() . '.' . $contract->getClientOriginalExtension();
            $contract->storeAs('public/upload', $contractDoc);
            $user->contract  =   $contractDoc;
        }

        if ($request->hasFile('application')) {
            $application    = $request->file('application');
            $applicationDoc = uniqid() . '.' . $application->getClientOriginalExtension();
            $application->storeAs('public/upload', $applicationDoc);
            $user->application  =   $applicationDoc;
        }


        if (!$user) {
            return redirect()->back()->with('error', 'User not found');
        }

        if ($request->input('role_id') === '1') {

            $user->update([
                'name'          =>   $request->input('name'),
                'email'         =>   $request->input('email'),
                'phone'         =>   $request->input('phone'),
                'role_id'       =>   $request->input('role_id'),

            ]);
            return redirect()->back()->with('message', 'Admin created successfully!');
        } else {
            $user->update([
                'name'              =>   $request->input('name'),
                'email'             =>   $request->input('email'),
                'role_id'           =>   $request->input('role_id'),
                'first_name'        =>   $request->input('first_name'),
                'middle_name'       =>   $request->input('middle_name'),
                'last_name'         =>   $request->input('last_name'),
                'status'            =>   $request->input('status'),
                'position'          =>   $request->input('position'),
                'nssf'              =>   $request->input('nssf'),
                'enddate'           =>   $request->input('enddate'),
                'phone'             =>   $request->input('phone'),
                'joining_date'      =>   $request->input('joining_date'),
                'start_date'        =>   $request->input('start_date'),
                'termination_date'  =>   $request->input('termination_date'),
                'termination_letter' =>   $request->input('termination_letter'),
                'contract_period'   =>   $request->input('contract_period'),
                'tin'               =>   $request->input('tin'),
                'nida'              =>   $request->input('nida')
            ]);
        }
        return redirect()->back()->with('message', 'Changes have been updated successfully!');
    }


    public function editAdmin($id)
    {
        $user  = User::find($id);
        return view('user.editadmin', compact('user'));
    }
    public function editAdminData(Request $request, $id)
    {
        $admin = User::find($id);
        $admin->update([
            'name'          =>   $request->input('name'),
            'email'         =>   $request->input('email'),
            'phone'         =>   $request->input('phone'),
            'role_id'       =>   $request->input('role_id'),
        ]);
        return redirect()->back()->with('message', 'Changes are updated successfully!');
    }
}
