<?php

namespace App\Http\Controllers;

use App\Models\RecieveDoc;
use App\Models\Tasks;
use App\Models\User;
use Illuminate\Http\Request;

class ReportController extends Controller
{
    public function dailyreport()
    {
        return view('reports.daily');
    }
    public function  dailyreportData(Request $request)
    {
        $date = $request->input('daterepo');
        //$date = '2024-01-02';
        //$data = Tasks::whereRaw("DATE_FORMAT(created_at, '%m/%d/%y') = ?", $date)->first();
        $data = Tasks::whereDate('created_at', '=', date('Y-m-d', strtotime($date)))->first();
        return response()->json($data);
    }


    public function taskReport()
    {
        return view('reports.tasks_report');
    }
    public function checkListReport()
    {
        return view('reports.checklist_report');
    }
    public function checkListReportStore(Request $request)
    {
        $request->validate([
            'start_date' => 'required|date',
            'end_date' => 'required|date|after_or_equal:from_date',
        ]);

        // Retrieve data based on dates
        $fromDate = $request->input('start_date');
        $toDate = $request->input('end_date');

        // Query data using the model
        $data = RecieveDoc::whereBetween('created_by', [$fromDate, $toDate])
            ->get();

        return response()->json($data);
    }
    public function kpiReport()
    {
        return view('reports.kpi_report');
    }
    public function documentReceived()
    {
        return view('reports.receive_doc_report');
    }
    public function docReceivedStore(Request $request)
    {
        $request->validate([
            'daterange' => 'required|string',
            'module'    => 'required|string',
        ]);

        $dateRange = explode(' - ', $request->input('daterange'));
        $startDate = \Carbon\Carbon::createFromFormat('m/d/Y', $dateRange[0])->startOfDay();
        $endDate   = \Carbon\Carbon::createFromFormat('m/d/Y', $dateRange[1])->endOfDay();
        $module    = $request->module;

        if ($module === 'tasks') {
            $tasks = Tasks::whereBetween('created_at', [$startDate, $endDate])->get();
        } elseif ($module === 'kpi') {
            // Replace 'Kpi' with your actual model for KPI
            //$tasks = Kpi::whereBetween('created_at', [$startDate, $endDate])->get();
        } else {
            return redirect()->back()->withErrors(['Invalid module selected']);
        }

        return view('reports.receive_doc_report', compact('tasks'));
    }
    public function presetReport()
    {
        $users =  User::all();
        return view('reports.preset_report', compact('users'));
    }
    public function presetReportStore(Request $request)
    {
        $period     = $request->period;
        $user       = $request->userId;
        $module    = $request->module;
        if ($module == 'tasks') {
        }

        return view('reports.receive_doc_report', compact('data'));
    }
    public function customReport()
    {
        return view('reports.custom_report');
    }
    public function customReportStore(Request $request)
    {
        $module    = $request->module;
        $date      = $request->input('daterange');
        $dateRange = explode(' - ', $date);
        $startDate = \Carbon\Carbon::createFromFormat('m/d/Y', $dateRange[0])->startOfDay();
        $endDate   = \Carbon\Carbon::createFromFormat('m/d/Y', $dateRange[1])->endOfDay();

        if ($module == "tasks") {
            $data = Tasks::whereBetween('created_at', [$startDate, $endDate])->get();
            return view('reports.custom_report', compact('data'));
        } else {
            return redirect()->back()->with('error', 'Invalid Module Selected!');
        }


        /*
        $startDate = \Carbon\Carbon::createFromFormat('m/d/Y', $dateRange[0])->startOfDay();
        $endDate   = \Carbon\Carbon::createFromFormat('m/d/Y', $dateRange[1])->endOfDay();
        $module    = $request->module;

        if ($module === 'tasks') {
            $data = Tasks::whereBetween('created_at', [$startDate, $endDate])->get();
        } elseif ($module === 'kpi') {
            // Replace 'Kpi' with your actual model for KPI
            //$tasks = Kpi::whereBetween('created_at', [$startDate, $endDate])->get();
        } else {
            return redirect()->back()->withErrors(['Invalid module selected']);
        }*/
    }
}
