<?php

namespace App\Http\Controllers;

use App\Models\Client;
use App\Models\ClientsService;
use App\Models\Tasks;
use App\Models\Employee;
use App\Models\KPI_Tracker;
use App\Models\Postcheck_Attachment;
use App\Models\Postchecks;
use App\Models\Precheck_Attachment;
use App\Models\Prechecks;
use App\Models\RecieveDoc;
use App\Models\Service;
use App\Models\Task_Comments;
use App\Models\Task_Post;
use App\Models\User;
use Carbon\Carbon;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use PhpParser\Node\Expr\Empty_;
use Spatie\Permission\Contracts\Role as ContractsRole;
use Spatie\Permission\Models\Role;

class TasksController extends Controller
{
    public function taskjob(Request $request)
    {
        $role  = Role::find(Auth::user()->role_id);
        $user = Auth::user()->id;
        $tasks = Tasks::with('EachTask', 'clientservice', 'userAssign', 'juniorAssign', 'client')->get();

        //return view('task.tasks', compact('tasks'));
        if (Auth::user()->role_id < 2) {
            $tasks = Tasks::with('EachTask', 'clientservice.service', 'userAssign', 'juniorAssign', 'client')->get();
            //Tasks::with('client.clientserv.service', 'EachTask', 'userAssign', 'juniorAssign')->get();
            return view('task.tasks', compact('tasks'));
        } elseif (Auth::user()->role_id == 2 || Auth::user()->role_id == 3) {
            $tasks = Tasks::with('EachTask', 'clientservice.service', 'userAssign', 'juniorAssign', 'client')
                ->where('user_id', '=', $user)
                ->get();
            return view('task.tasks', compact('tasks'));
        } elseif (Auth::user()->role_id == 4) {
            $tasks = Tasks::with('EachTask', 'clientservice.service', 'userAssign', 'juniorAssign', 'client')
                ->where('junior_id', '=', $user)
                ->get();
            return view('task.tasks', compact('tasks'));
        } else {
            return false;
        }
    }
    public function notaskjob()
    {
        return view('task.notasks');
    }
    public function addemployee() {}

    public function create()
    {
        //$employees = Employee::all();
        $client = Client::all();
        $clientservice = ClientsService::all();
        $users = User::with('roleuser')->get();

        $role = Role::find(Auth::user()->role_id);
        if ($role->hasPermissionTo('task-add')) {
            return view('task.createTask', compact(['clientservice', 'client', 'users']));
        } else {
            return redirect()->route('error.403');
        }
    }

    public function storeTask(Request $request)
    {
        $task = new Tasks();

        $task->clients_id                            =    $request->clients_id;
        $task->user_id                               =    $request->employees;
        $task->clientservices_id                     =    $request->service;
        //$task->category                            =    $request->category;
        $task->start_date                            =    $request->start_date;
        $task->end_date                              =    $request->end_date;
        $task->job_date_documents_received_precheck  =    $request->job_date_documents_received_precheck;
        $task->job_kpi_enabled                       =    $request->job_kpi_enabled;
        $task->job_kpi_deadline_to_receive_document  =    $request->job_kpi_deadline_to_receive_document;
        $task->job_date_documents_receive            =    $request->job_date_documents_receive;
        $task->kpi_early_point                       =    $request->kpi_early_point;
        $task->kpi_late_point                        =    $request->kpi_late_point;
        $task->kpi_on_time_point                     =    "0";
        $task->task_target_day                      =    $request->task_target_days;
        $task->save();
        $taskId = $task->id;
        $userId = $task->user_id;
        //return response()->json($task);
        if ($task->job_kpi_enabled === 'Yes') {
            KPI_Tracker::create([
                'tasks_id'           => $taskId,
                'users_id'           => $userId,
                'kpi_early_point'    => $task->kpi_early_point,
                'kpi_late_point'     => $task->kpi_late_point,
                'kpi_on_time_point'  => "0",
                'task_target_day'    => $task->task_target_day,
                'created_at'         => now(),
                'updated_at'         => now(),
            ]);
            $task->save();
        }
        return redirect()->back()->with('message', 'Task created successfully');
    }

    public function receiveDoc($id)
    {
        return view('task.receivedoc');
    }

    public function documents($id)
    {
        $task = Tasks::with('client.clientserv.serv', 'employee')->find($id);
        return view('task.receivedoc', compact('task'));
    }
    public function receivedocStore(Request $request)
    {

        $receiveDoc = new RecieveDoc();
        $receiveDoc->task_id       =    $request->taskNo;
        $receiveDoc->client_id     =    $request->client;
        $receiveDoc->service_id    =    $request->service;
        $receiveDoc->dateReceived  =    $request->dateReceived;
        $receiveDoc->note          =    $request->note;
        $receiveDoc->quantity      =    $request->quantity;
        $receiveDoc->fileType      =    $request->fileType;
        $receiveDoc->narration     =    $request->narration;

        $receiveDoc->save();
        return redirect()->back()->with('message', 'Your successfully Receive Document!');
    }
    public function documentsstore($id)
    {
        return view('task.receivedoc');
    }
    public function updateview($id)
    {
        $tasks = Tasks::with('client.clientserv.serv', 'employee')->get();
        foreach ($tasks as $row) {
            return view('task.update', compact('row'));
        }
    }

    public function activate(Request $request) {}

    public function taskuser()
    {
        return view('task.tasksUser');
    }

    public function taskProg($id)
    {

        $taskpost = DB::table('task_post')->where('task_id', $id)->get();
        $approver = User::all();
        $mainPost = Task_Post::with('postuser')->where('task_id', $id)->orderBy('created_at', 'desc')->get();

        $comments        = Task_Comments::where('task_id', $id)->orderBy('created_at', 'desc')->get();
        $mainTask        = Tasks::with('client.clientserv.serv', 'clientservice.service', 'userAssign', 'juniorAssign')->find($id);
        $servId          = $mainTask->clientservice->service->id;

        $precheck        = Prechecks::where('service_id', $servId)->get();
        $postcheck       = Postchecks::where('service_id', $servId)->get();

        $precheckStatus  = Precheck_Attachment::where('task_id', $id)->first();
        $postcheckStatus = Postcheck_Attachment::where('task_id', $id)->first();

        //$precheckAttach  = Precheck_Attachment::where('task_id', $id)->get();
        $precheckAttach = Precheck_Attachment::where('task_id', $id)->get()->keyBy('serviceprecheck_id');
        $postcheckAttach = Postcheck_Attachment::where('task_id', $id)->get();

        $result = DB::table('precheck_attachment')
            ->join('service_prechecks', 'precheck_attachment.id', '=', 'service_prechecks.id')
            ->select('precheck_attachment.*', 'service_prechecks.*')
            ->where('precheck_attachment.task_id', '=', $id)
            //->where('service_id', $servId)
            ->get();
        ///Precheck Display
        $precheckRes1 = Prechecks::with([
            'attachments' => function ($query) use ($id) {
                $query->where('task_id', $id);
            }
        ])->where('service_id', $servId)->get();

        ///Postcheck Display
        $postcheckRes = Postchecks::with([
            'postattachments' => function ($query) use ($id) {
                $query->where('task_id', $id);
            }
        ])->where('service_id', $servId)->get();

        /*$precheck = DB::select("
            SELECT p.*, pa.precheck_attach, pa.task_id, pa.status
            FROM service_prechecks p LEFT JOIN precheck_attachment pa ON p.id = pa.serviceprecheck_id WHERE p.service_id = ?", [$servId]);*/

        /*$precheckRes = DB::table('service_prechecks as p')
            ->leftJoin('precheck_attachment as pa', function ($join) use ($id) {
                $join->on('p.id', '=', 'pa.serviceprecheck_id')
                    ->where('pa.task_id', '=', $id);
            })
            ->where('p.service_id', $servId)
            ->select('p.*', 'pa.precheck_attach', 'pa.task_id', 'pa.status')
            ->get();*/


        /*******---------- Retrive the data from Precheck_attactment Table --------************/
        $completePre  = DB::table('precheck_attachment')
            ->join('service_prechecks', 'precheck_attachment.id', '=', 'service_prechecks.id')
            ->select('precheck_attachment.*', 'service_prechecks.*')
            ->where('precheck_attachment.task_id', '=', $id)
            ->first();

        /*******---------- Retrive the data from Postcheck_attactment Table --------************/
        $completePost  = DB::table('postcheck_attachment')
            ->join('service_postchecks', 'postcheck_attachment.id', '=', 'service_postchecks.id')
            ->select('postcheck_attachment.*', 'service_postchecks.*')
            ->where('postcheck_attachment.task_id', '=', $id)
            ->first();
        foreach ($comments as $comment) {
            $commentTimestamp = $comment->created_at;
            // $timeDif = calculateTimeDifference($commentTimestamp);
        }
        //return response()->json($precheckRes1);
        return view('task.taskprogress', compact('mainTask', 'precheck', 'postcheck', 'completePre', 'completePost', 'mainPost', 'comments', 'precheckStatus', 'postcheckStatus', 'precheckRes1', 'postcheckRes'));
    }

    /********************* Pre Check Item One By One *******************/
    public function getTaskProgData($id)
    {
        $taskpost = DB::table('task_post')->where('task_id', $id)->get();
        $approver = User::all();
        $mainPost = Task_Post::with('postuser')->where('task_id', $id)->orderBy('created_at', 'desc')->get();
        $comments = Task_Comments::where('task_id', $id)->orderBy('created_at', 'desc')->get();
        $mainTask = Tasks::with('client.clientserv.serv', 'clientservice.service', 'userAssign', 'juniorAssign')->find($id);

        $servId = $mainTask->clientservice->service->id;
        $precheckRes1 = Prechecks::with(['attachments' => function ($query) use ($id) {
            $query->where('task_id', $id);
        }])->where('service_id', $servId)->get();

        $postcheckRes = Postchecks::with(['postattachments' => function ($query) use ($id) {
            $query->where('task_id', $id);
        }])->where('service_id', $servId)->get();

        return response()->json([
            'mainTask' => $mainTask,
            'precheckRes1' => $precheckRes1,
            'postcheckRes' => $postcheckRes,
            'mainPost' => $mainPost,
            'comments' => $comments,
        ]);
    }


    /********************* Pre Check Item One By One *******************/


    public function PreheckItem(Request $request, $id)
    {

        if ($request->hasFile('precheck_file')) {
            $file = $request->file('precheck_file');
            $fileName = uniqid() . '.' . $file->getClientOriginalExtension();
            $filePath = $file->storeAs('public/checklist', $fileName); // Store file
        } else {
            return back()->with('error', 'No file uploaded.');
        }
        $precheck = new Precheck_Attachment();
        $precheck->task_id              = $request->input('task_id');
        $precheck->serviceprecheck_id   = $request->input('precheck_id');
        $precheck->precheck_attach      = $fileName;
        $precheck->status               = 'yes';
        $precheck->save();
        return redirect()->back()->with('message', 'Your successfully upload document!');

        /*try {
            if ($request->hasFile('precheck_attach')) {
                $file = $request->file('precheck_attach');
                $pdfFileName = uniqid() . '.' . $file->getClientOriginalExtension();
                $file->storeAs('public/checklist', $pdfFileName);
            }
            $item = Precheck_Attachment::create([
                'task_id'            => $id,
                'precheck_attach'    => $pdfFileName,
                'serviceprecheck_id' => $request->input('precheck_id'),
                'status'             => $request->input('status')
            ]);
        } catch (Exception $e) {
            return response()->json(['error' => $e->getMessage()]);
        }*/
    }
    /********************* Update Pre Check Item One By One *******************/
    public function UpdatePreheckItem(Request $request, $id)
    {
        $updatePrecheck = Precheck_Attachment::find($id);
        if ($request->hasFile('precheck_file')) {
            $file = $request->file('precheck_file');
            $fileName = uniqid() . '.' . $file->getClientOriginalExtension();
            $filePath = $file->storeAs('public/checklist', $fileName); // Store file
        } else {
            return back()->with('error', 'No file uploaded.');
        }
        $updatePrecheck->precheck_attach      = $fileName;
        $updatePrecheck->status               = 'yes';
        $updatePrecheck->save();
        return redirect()->back()->with('message', 'Your successfully Update the document!');
    }

    /********************* Post Check Item One By One *******************/
    public function PostheckItem(Request $request, $id)
    {

        if ($request->hasFile('postcheck_attach')) {
            $file = $request->file('postcheck_attach');
            $fileName = uniqid() . '.' . $file->getClientOriginalExtension();
            $filePath = $file->storeAs('public/checklist', $fileName); // Store file
        } else {
            return back()->with('error', 'No file uploaded.');
        }
        $postcheck = new Postcheck_Attachment();
        $postcheck->task_id              = $request->input('task_id');
        $postcheck->servicepostcheck_id    = $request->input('postcheck_id');
        $postcheck->postcheck_attach      = $fileName;
        $postcheck->status               = 'yes';
        $postcheck->save();
        return redirect()->back()->with('message', 'Your successfully upload document!');
    }

    /********************* Update Post Check Item One By One *******************/
    public function UpdatePostheckItem(Request $request, $id)
    {
        $updatePostcheck = Postcheck_Attachment::find($id);
        if ($request->hasFile('postcheck_attach')) {
            $file = $request->file('postcheck_attach');
            $fileName = uniqid() . '.' . $file->getClientOriginalExtension();
            $filePath = $file->storeAs('public/checklist', $fileName); // Store file
        } else {
            return back()->with('error', 'No file uploaded.');
        }
        $updatePostcheck->postcheck_attach      = $fileName;
        $updatePostcheck->status               = 'yes';
        $updatePostcheck->save();
        return redirect()->back()->with('message', 'Your successfully Update the document!');
    }
    /********************* Time Different *******************/
    function calculateTimeDifference($commentTimestamp)
    {
        $currentTime = Carbon::now();
        $commentTime = Carbon::parse($commentTimestamp);

        $timeDifference = $commentTime->diffInSeconds($currentTime);

        if ($timeDifference < 60) {
            return $timeDifference . ' sec ago';
        } elseif ($timeDifference < 3600) {
            $minutes = round($timeDifference / 60);
            return $minutes . ' min ago';
        } elseif ($timeDifference < 86400) {
            $hours = round($timeDifference / 3600);
            return $hours . ' hr ago';
        } else {
            $days = round($timeDifference / 86400);
            return $days . ' days ago';
        }
    }

    public function approveTask(Request $request, $id)
    {
        $approveTask = Tasks::find($id);
        $approveTask->approve_status  =  $request->approve;
        $approveTask->update();
        return redirect()->back();
    }
    //approve pre checklist
    public function approvePreCheckTask(Request $request, $id)
    {
        $approveTask = Tasks::find($id);
        $approveTask->pre_approval  =  'yes';
        $approveTask->update();
        return redirect()->back()->with('message', 'Task Approved Successfully!');
    }

    //approve pre checklist
    public function approvePostCheckTask(Request $request, $id)
    {
        $approveTask = Tasks::find($id);
        $approveTask->post_approval  =  'yes';
        $approveTask->update();
        return redirect()->back()->with('message', 'Task Approved Successfully!');
    }
    /************** Complete Task ***********/
    public function completeTask($id)
    {
        $task = Tasks::find($id);
        $task->complete_task = 'yes';
        $task->update();
        return redirect()->back()->with('message', 'Task is Completed Successfully!');
    }

    /************** Suspend Taask ****************/
    public function suspendTask($id)
    {
        $task = Tasks::find($id);
        $task->suspend_task = 'yes';
        $task->update();
        return redirect()->back()->with('message', 'Task is Suspended Successfully!');
    }

    public function PostProcess(Request $request)
    {

        $data = Task_Post::create([
            'user_id'      =>  $request->user_id,
            'post'         =>  $request->taskPost,
            'task_id'      =>  $request->task_id,
            'postcheck_id'  =>  $request->postcheck_id
        ]);

        return redirect()->back();
    }
    public function PostFetchData()
    {
        $getdata = Task_Post::all();
        return response()->json($getdata);
    }
    public function Postdata()
    {
        //$mainPost = Task_Post::all();
        // dd($mainPost);
        //if (count($mainPost) > 0) {
        //    return response()->json($mainPost);
        //}
    }
    public function TaskPost(Request $request)
    {
        $taskpost = Task_Post::create([
            'user_id'     =>  Auth::User()->id,
            'post'        =>  $request->taskPost,
            'task_id'     =>  $request->task_id,
        ]);

        return redirect()->back()->with('taskpost', $taskpost);
    }
    public function taskpostview() {}
    public function commentsview()
    {
        return response(['success' => 'comment index!']);
    }
    /********* Add Comment *************/
    public function comments(Request $request)
    {
        $comment = $request->validate([
            'user_id' => 'required',
            'comments' => 'required',
            'taskpost_id' => 'required',
            'task_id'  => 'required'
        ]);
        Task_Comments::create($comment);
        return redirect()->back();
    }
    /*public function Precheck(Request $request, $id)
    {
        $status               = $request->input('status');
        $taskId               = $request->input('task_id');
        $precheck_id          = $request->input('precheck_id');
        $attachments          = $request->file('precheck_attach');
        if ($attachments) {
            foreach ($attachments as $index => $attachment) {
                $pdfFileName = uniqid() . '.' . $attachment->getClientOriginalExtension();
                $attachment->storeAs('public/checklist', $pdfFileName);
                Precheck_Attachment::create([
                    'precheck_attach'       => $pdfFileName,
                    'task_id'               => $taskId,
                    'serviceprecheck_id'    => $precheck_id[$index],
                    'status'                => $status[$index]
                ]);
            }
        }
        return redirect()->back()->with('message', 'Pre checklist was confirmed!');
    }*/

    /*public function CheckPrecheckAttach(Request $request, $id)
    {
        $status = Precheck_Attachment::findOrFail($id);

        $showViewUpdateBtn = ($status->status === 'yes');
        $showUploadBtn = ($status->status === 'no');
        return response()->json([
            'status'            => $status,
            'showViewUpdateBtn' => $showViewUpdateBtn,
            'showUploadBtn'     => $showUploadBtn
        ]);
    }*/
    public function CheckPrecheckAttach(Request $request, $id)
    {
        $PreCheckStatus = Precheck_Attachment::where('task_id', $id)->get();

        if ($PreCheckStatus->isEmpty()) {
            return response()->json(['error' => 'No attachments found'], 404);
        }

        return response()->json([
            'statuses' => $PreCheckStatus->map(function ($status) {
                return [
                    'id'                => $status->id,
                    'status'            => $status->status,
                    'showViewUpdateBtn' => $status->status === 'yes',
                    'showUploadBtn'     => $status->status === 'no',
                ];
            }),
        ]);
    }

    /********* Add Precheck *************/
    public function Precheck(Request $request, $id)
    {
        $request->validate([
            'precheck_attach' => 'required|mimes:pdf,doc,docx,xls,xlsx',
            'precheck_id' => 'required',
            'task_id' => 'required',
            'status' => 'required'
        ]);

        try {
            if ($request->hasFile('precheck_attach')) {
                $file = $request->file('precheck_attach');
                $pdfFileName = uniqid() . '.' . $file->getClientOriginalExtension();
                $file->storeAs('public/checklist', $pdfFileName);

                Precheck_Attachment::create([
                    'precheck_attach' => $pdfFileName,
                    'task_id' => $request->task_id,
                    'serviceprecheck_id' => $request->precheck_id,
                    'status' => $request->status
                ]);

                return response()->json(['message' => 'File uploaded successfully!'], 200);
            }
        } catch (\Exception $e) {
            return response()->json(['message' => 'File upload failed: ' . $e->getMessage()], 500);
        }

        return response()->json(['message' => 'No file uploaded.'], 400);
    }
    public function Postcheck(Request $request, $id)
    {
        $request->validate([
            'postcheck_attach' => 'required|mimes:pdf,doc,docx,xls,xlsx',
            'postcheck_id' => 'required',
            'task_id' => 'required',
            'status' => 'required'
        ]);

        try {
            if ($request->hasFile('postcheck_attach')) {
                $file = $request->file('postcheck_attach');
                $pdfFileName = uniqid() . '.' . $file->getClientOriginalExtension();
                $file->storeAs('public/checklist', $pdfFileName);

                Postcheck_Attachment::create([
                    'postcheck_attach' => $pdfFileName,
                    'task_id'           => $request->task_id,
                    'serviceprecheck_id' => $request->postcheck_id,
                    'status' => $request->status
                ]);

                return response()->json(['message' => 'File uploaded successfully!'], 200);
            }
        } catch (\Exception $e) {
            return response()->json(['message' => 'File upload failed: ' . $e->getMessage()], 500);
        }

        return response()->json(['message' => 'No file uploaded.'], 400);
    }
    /*public function Postcheck(Request $request, $id)
    {
        $status               = $request->input('status');
        $taskId               = $request->input('task_id');
        $postcheck_id         = $request->input('postcheck_id');
        $attachments          = $request->file('postcheck_attach');
        if ($attachments) {
            foreach ($attachments as $index => $attachment) {
                $pdfFileName = uniqid() . '.' . $attachment->getClientOriginalExtension();
                $attachment->storeAs('public/checklist', $pdfFileName);
                Postcheck_Attachment::create([
                    'postcheck_attach'      => $pdfFileName,
                    'task_id'               => $taskId,
                    'servicepostcheck_id'   => $postcheck_id[$index],
                    'status'                => $status[$index]
                ]);
            }
        }
        return redirect()->back()->with('message', 'Post checklist was confirmed!');
    }*/
    public function AssignJunior($id)
    {
        $junior  = User::with('roleuser')->get();

        $task = Tasks::with('client.clientservice.serv', 'userAssign')
            ->where('id', '=', $id)
            ->first();
        return view('task.assignjunior', compact('task', 'junior'));
    }
    public function AssignJuniorStoreData(Request $request, $id)
    {
        $task = Tasks::find($id);
        if ($task) {
            $task->junior_id   = $request->junior;
            $task->update();
        }
        return redirect()->back()->with('message', 'You assign task successfuly!');
    }
    public function ReassignSeniorIndex($id)
    {
        $senior = User::with('roleuser')->get();
        $task = Tasks::with('client.clientservice.serv', 'userAssign')
            ->where('id', '=', $id)
            ->first();
        return view('task.assignsenior', compact('task', 'senior'));
    }
    public function ReassignSenior(Request $request, $id)
    {
        $task = Tasks::find($id);
        if ($task) {
            $task->user_id = $request->senior;
            $task->update();
        }
        return redirect()->back()->with('message', 'You reassign senior staff to task successfuly!');
    }

    /*public function getTreeData()
    {
        // Example data structure representing years, months, services, and files
        $treeData = [
            ['id' => '2024', 'parent' => '#', 'text' => '2024'],
            ['id' => '2024-jan', 'parent' => '2024', 'text' => 'January'],
            ['id' => '2024-jan-service1', 'parent' => '2024-jan', 'text' => 'Payroll'],
            ['id' => '2024-jan-service1-file1', 'parent' => '2024-jan-service1', 'text' => 'File 1', 'state' => ['opened' => true]],
            ['id' => '2024-jan-service1-file2', 'parent' => '2024-jan-service1', 'text' => 'File 2', 'state' => ['opened' => true]],
            // Add more nodes as needed
        ];

        return response()->json($treeData);
    }*/
}
