<?php

namespace App\Http\Controllers;

use App\Models\Template;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class TemplateController extends Controller
{
    public function template()
    {
        $templates = Template::all();
        $files     = Storage::files('public/uploads');
        foreach ($files as $file)
            return view('template.template', compact('templates', 'file'));
    }
    public function newTemplate()
    {
        return view('template.createtemplate');
    }
    public function store(Request $request)
    {
        $request->validate([
            'file' => 'required|file|mimes:pdf|max:2048',
        ]);

        try {
            $filepdf = $request->file('file');
            if ($filepdf->isValid()) {
                $fileName = uniqid() . '.' . $filepdf->getClientOriginalExtension();
                $filepdf->storeAs('public/template', $fileName);

                $template = new Template();
                $template->name = $request->name;
                $template->description = $request->description;
                $template->is_new = true;
                $template->file = $fileName;
                $template->save();

                return redirect()->back()->with('message', 'Template created successfully.');
            }
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->withErrors(['file' => 'An error occurred: ' . $e->getMessage()]);
        }

        /*$filepdf = $request->file('file');
        if ($filepdf->isValid()) {
            $fileName = uniqid() . '.' . $filepdf->getClientOriginalExtension();
            $filepdf->storeAs('public/template', $fileName);

            $template = new Template();
            $template->name = $request->name;
            $template->description = $request->description;
            $template->is_new = true;
            $template->file = $fileName;
            $template->save();

            return redirect()->back()->with('message', 'Template created successfully.');
        } else {
            return redirect()->back()->withInput()->withErrors(['file' => 'Invalid file uploaded.']);
        }*/
    }
    public function templateBadge()
    {
        $temp = Template::where('is_new', true)->orderBy('created_at', 'desc')->first();
    }
    public function DeleteTemplate($id)
    {
        $temp = Template::find($id);
        if (!empty($temp)) {
            Storage::delete('/public/template/' . $temp->file);
            $temp->delete();
            return redirect()->back()->with('message', 'Template deleted successfully!');
        } else {
            return redirect()->back()->with('error', "No template found!");
        }
    }
}
