<?php

namespace App\Http\Controllers;

use App\Models\Role;
use App\Models\User;
use Illuminate\Http\Request;
use Spatie\Permission\Traits\HasRoles;
use Illuminate\Support\Facades\Hash;

class UserController extends Controller
{
    use HasRoles;

    public function index()
    {
        return view('user.adduser');
    }
    public function addview()
    {
        $user = User::with('roleuser')->get();
        return view('user.userlist', compact('user'));
    }
    public function store()
    {
        //... code...
    }
    public function editview($id)
    {
        $user = User::find($id);
        return view('user.edit', compact('user'));
    }
    public function delete($id)
    {
        $user = User::find($id);
        if ($user) {
            $user->delete();
            return redirect()->back()->with('message', 'User has been deleted successfully!');
        } else {
            return redirect()->back()->with('error', 'User not found!');
        }
    }
    public function suspend($id)
    {
        $user = User::find($id);
        if ($user) {
            $user->status = "Inactive";
            $user->update();
            return redirect()->back()->with('message', 'User has been suspended!');
        } else {
            return redirect()->back()->with('error', 'User not found!');
        }
    }
    public function active($id)
    {
        $bannedUser = User::find($id);
        if ($bannedUser) {
            $bannedUser->status = "Active";
            $bannedUser->update();
            return redirect()->back()->with('message', 'User has been activated successfully!');
        } else {
            return redirect()->back()->with('error', 'User not found!');
        }
    }
    public function permission($id)
    {
        $user = User::find($id);
        return view('role.permission', compact('user'));
    }
    public function changepermission(Request $request, $id)
    {
    }
    public function changePassIndex(Request $request, $id)
    {
        $target = User::find($id);
        if (!$target) {
            abort(404);
        } else {
            return view('user.change_password', compact('target'));
        }
    }
    public function changePassUpdate(Request $request, $id)
    {
        $targetuser = User::find($id);

        if ($targetuser) {
            $targetuser->password = Hash::make($request->input('password'));
            $targetuser->update();
        }
        return redirect()->back()->with('message', 'Password updated successfully!');
    }
}
