<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasOne;

class ContactPersonLimited extends Model
{
    use HasFactory;

    protected $primary = 'id';

    protected $table = 'contact_person_limiteds';

    protected $fillable = [
        'client_id',
        'contactpeople_id',
        'position',
        'number_shares',
        'share_percent',
    ];
    public function contactPersonltd()
    {
        // return $this->hasOne(ContactPerson::class, 'id');
        return $this->belongsTo(ContactPerson::class, 'contactpeople_id', 'id');
    }
    public function Assigneduser()
    {
        return $this->hasOne(Client::class);
    }
    public function contLimit(): HasOne
    {
        return $this->hasOne(ContactPerson::class);
    }
}
