<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class DispatchJob extends Model
{
    use HasFactory;

    protected $primarykey = 'id';

    protected $table = 'dispatchjob';

    protected $fillable = [
        'client_name',
        'dispatchCreator',
        'dispatch_no',
        'dispatch_attachment'
    ];
    public function client()
    {
        return $this->belongsTo(Client::class, 'id');
    }
}
