<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LeaveRequest extends Model
{
    use HasFactory;

    protected $primarykey = 'id';

    protected $table = 'leave_request';

    protected $fillable  = [
        'user_id',
        'dateFrom',
        'day_counter',
        'dateTo',
        'request_type',
        'status'
    ];

    public function userRequest()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
}
